package dSelf;

/**
 * Argument slots are data slots with a special semantic, that occur 
 * in method objects. They represent the place holders for the argu-
 * ments of methods. They are declared directly in the binary or 
 * keyward message (e.g. + arg = (...)) or with a leading column in
 * slot declaration.
 */
public class ArgumentSlot extends DataSlotImpl{
  
 /** 
  * Creates a new argument slot with the specified name, content and
  * annotation.
  *
  * @param n The name of this slot
  * @param newContent The content for this slot
  * @param anno The annotation for this slot
  */ 
  public ArgumentSlot(String n, DataSO newContent, String anno){
  
    super(n , newContent, anno);
  }
  
 /** 
  * Creates a new argument slot with the specified name.
  *
  * @param n The name of this slot
  */ 
  public ArgumentSlot(String n){

    super(n);
  }
 
 /**
  * Returns a clone of this slot.
  */ 
  public Object clone(){
  
    return new ArgumentSlot(name, content, annotation);
  }
 
}  
