package dSelf;

/**
 * AssignmentSO is an class, that repesents the content of assignment
 * slots ({@link dSelf.AssignmentSlot}). It's not really a dSelf object,
 * that is returned to the user, but it is needed for the lookup algorithm
 * to detect, that the content of a data slot ({@link dSelf.DataSlot})
 * shall be replaced.
 */
public abstract class AssignmentSO extends dSelfObject implements RemoteReferenceSO{
  
 /** 
  * Returns the name of this object (i.e. "assignment"). 
  */ 
  public String getName(){
  
    return "assignment";
  }

 /**
  * Sets the new content of the slot, to which this assignment object
  * refers.
  *
  * @param content The data object for the data slot
  */ 
  protected abstract void setContent(DataSO content);
}

