package dSelf;

/**
 * The class LocalObjectVectorSO repesents an object vector of dSelf,
 * that is located on the local dSelf-VM.
 * LocalObjectVectorSO is a primitive dSelf object and so it has only one
 * parent slot called "parent", that is shared by all object vectors.
 * The object, that "parent" refers to has initialy only one
 * parent slot, also called "parent" that refers to the lobby.
 * This object is dedicated to include the user-defined methods,
 * that are shared by all object vectors.
 */
public class LocalObjectVectorSO extends ObjectVectorSO{

  /** An array with the contents of this vector. */
  protected DataSO[] objVector = new DataSO[0];
  
 /** 
  * Creates a new empty object vector. 
  */
  public LocalObjectVectorSO(){}
  
 /** 
  * Creates a new object vector with the given content.
  *
  * @param oVec The new content for this vector 
  */
  public LocalObjectVectorSO(DataSO[] oVec){
  
    objVector = oVec;
  }

 /**
  * Returns the object at the specified position.
  *
  * @param pos The index of the demanded object
  * @return The object at the specified position
  */
  public DataSO getObjectAt(int pos) throws ArrayIndexOutOfBoundsException{
  
    return objVector[pos]; 
  }

 /**
  * Puts an object at the specified position.
  *
  * @param pos The index, where this object is put
  * @param arg The object, that is put at the specified position
  */
  public void putObjectAt(int pos, DataSO arg) 
      throws ArrayIndexOutOfBoundsException{
  
    objVector[pos] = arg; 
  }

 /**
  * Returns the length of this object vector.
  */
  public int getLength(){
  
    return objVector.length;
  }
}
