package dSelf;

public class LookupResult {
  public static final int NORMAL_METHOD = 1;
  public static final int BLOCK_METHOD = 2;
  public static final int NORMAL_DATA = 3;
  public static final int ASSIGNMENT = 4;
  
  private DataOrMethodSO holder;
  private dSelfObject value;

  public LookupResult(DataOrMethodSO holder, dSelfObject value) {
    this.holder = holder;
    this.value = value;
  }

  protected DataOrMethodSO getHolder() { return this.holder; }

  protected dSelfObject getValue() { return this.value; }

  protected int getCategory() {
    if (this.value instanceof MethodSO
	&& ! (this.value instanceof MethodActivationSO)
	&& ! ((MethodSO)this.value).isForBlock()) {

      return NORMAL_METHOD;
    }else if (this.value instanceof MethodSO
	      && ! (this.value instanceof MethodActivationSO)
	      && ((MethodSO)this.value).isForBlock()) {

      return BLOCK_METHOD;
    }else if (this.value instanceof AssignmentSO) {

      return ASSIGNMENT;
    }else {

      return NORMAL_DATA;
    }
  }

  /* If holder is transient, lookup result should not be cached. */
  protected boolean holderIsTransient() {
    if (holder instanceof MethodActivationSO)
      return true;
    else
      return false;
  }

  public String toString() {
    return "<"+holder+"/"+value+"("+getCategory()+")>";
  }
}
      
      
