package dSelf;

import java.util.Vector;

/**
 * MessageExpr represents the expressions of messages in dSelf. When 
 * message expressions are evaluated, then first a message object 
 * ({@link Message}) is created and its receiver is evaluated in context, 
 * that was given to this expression. After that, the message is sent
 * to this receiver ({@link DataOrMethodSO#dispatchMsg(Message)}) and
 * the result of this action returned.
 */
public abstract class MessageExpr implements CodeExpr{

  /** The receiver of this message. */
  protected CodeExpr receiver = null;
  /** A vector with the arguments of this message. */
  protected Vector methodArguments = new Vector();
  
 /** 
  * Creates a new message object, that represents the evaluated form
  * of this message expression.
  *
  * @param dSOVec A vector with the arguments of this message
  * @return The new created message
  */
  protected abstract Message createMessage(Vector dSOVec);
     
 /** 
  * Evaluates this message expression within the given context and returns 
  * the result caused by this message. 
  *
  * @param dSo The context, within this message expression is evaluated
  * @return The resulting dSelf object
  */
  public DataSO eval(DataOrMethodSO selfContext) throws dSelfException, NonLocalReturnException{
  
    Vector dSOVec = new Vector();
    
    for(int i=0; i<methodArguments.size(); i++)
      dSOVec.add(((CodeExpr)methodArguments.elementAt(i)).eval(selfContext));  

    if(receiver == null)
      return selfContext.dispatchMsg(createMessage(dSOVec)) ;

    return receiver.eval(selfContext).dispatchMsg(createMessage(dSOVec));
  }
}
