package dSelf;

import java.util.Vector;
import java.io.Serializable;
import dSelfVM;

/**
 * OrdinarySOExpr represents the expression for a method object.
 */
public class MethodSOExpr extends SlottedSOExpr implements Serializable{

  /** The code of this method. */
  protected ExprList exprList;
  
 /**
  * Creates a new method object expression with the given code and
  * no slots.
  *
  * @param expr The code for this method 
  */  
  public MethodSOExpr(ExprList expr){
  
    exprList = expr;
  }

 /**
  * Creates a new method object expression with the given code and
  * slot declarations.
  *
  * @param slotDecls The slot declarations of this object
  * @param expr The code for this method 
  */  
  public MethodSOExpr(SlotDeclarations slotDecls, ExprList expr){
  
    slotDeclarations = slotDecls;
    exprList = expr;
  }
  
 /**
  * Adds the given slot declarations to this object.
  *
  * @param slotDecls The new slot declarations
  */ 
  protected void addSlotDeclarations(SlotDeclarations slotDecls){
  
    Vector slots = slotDecls.getSlotDecls();

    for(int i=0; i<slots.size(); i++)
      addSlotDecl((SlotDecl)slots.get(i));
  }
  
 /**
  * Adds the given slot declarations to this object.
  *
  * @param slotDecls The new slot declarations
  * @return This object with the new slot declarations
  */ 
  public MethodSOExpr withSlotDeclarations(SlotDeclarations slotDecls){

    addSlotDeclarations(slotDecls); 
    return this;     
  }
  
 /**
  * Adds the given slot declaration to this object.
  *
  * @param slotDecl The new slot declaration
  */ 
  protected void addSlotDecl(SlotDecl slotDecl){
    
    slotDeclarations.addSlotDecl(slotDecl);
  }
  
 /**
  * Adds the given slot declaration to this object.
  *
  * @param slotDecl The new slot declaration
  * @return This object with the new slot declaration
  */ 
  public MethodSOExpr withSlotDecl(SlotDecl slotDecl){
    
    addSlotDecl(slotDecl);
    return this;
  }

 /**
  * Evaluates the slots of this object. It is used as the initializer
  * for method objects.
  *
  * @return A slot vector with the evaluated slots.
  */ 
  public MethodSO eval() 
      throws dSelfException, NonLocalReturnException{
   
    return new MethodSO(evalSlots(), exprList);    
  }    

  /** As eval() and mark it for block */
  public MethodSO evalForBlock(DataOrMethodSO context) 
      throws dSelfException, NonLocalReturnException{
   
    return new MethodSO(evalSlots(), exprList, context);    
  }    
}
