package dSelf;

import java.util.Vector;

/**
 * MethodSlot contains a method object.
 */
public class MethodSlotImpl implements MethodSlot{

 /** The content of this slot */ 
  protected MethodSO content;
  /** The name of this slot */
  protected String name;
  /** The annotation for this slot */
  protected String annotation = null;
  
 /** 
  * Creates a new method slot with the specified name, content and
  * annotation.
  *
  * @param n The name of this slot
  * @param newContent The content for this slot
  * @param anno The annotation for this slot
  */ 
  public MethodSlotImpl(String n, MethodSO newContent, String anno){
  
    name = n;
    annotation = anno;
    content = newContent;
  }

 /** 
  * Creates a new method slot with the specified name and content. 
  *
  * @param n The name of this slot
  * @param newContent The content for this slot
  */ 
  public MethodSlotImpl(String n, MethodSO newContent){
  
    name = n;
    content = newContent;
  }

 /** 
  * Creates a new method slot with the specified name.
  *
  * @param n The name of this slot
  */ 
  public MethodSlotImpl(String n){
  
    name = n;
  }

  public Object clone(){
  
    return new MethodSlotImpl(name, content, annotation);
  }

 /**
  * Returns a clone of this slot.
  */ 
  public dSelfObject getContent(){
  
    return content;
  }

 /** 
  * Sets a new annotation for this slot. If an old annotation already
  * exists, then the new one is appended to the old one.
  */
  public void setAnnotation(String a){
  
    if(a != null)
      annotation = a + (annotation == null ? "": annotation);
  }
 
 /**
  * Returns the annotation for this slot. If no annotation exists, then
  * "No annotation available." is returned.
  */   
  public String getAnnotation(){
  
    return annotation == null ? "No annotation available." : annotation;
  }  
  
  /** Returns the name of this slot */
  public String getName(){
  
    return name;
  }
}
