package dSelf;

import java.util.Vector;
import dSelfVM;

/**
 * The class NilSO repesents the nil object of dSelf.
 * NilSO is a primitive dSelf object and so it has only one
 * parent slot called "parent".
 * The object, that "parent" refers to has initialy only one
 * parent slot, also called "parent" that refers to the lobby.
 * This object is dedicated to include the user-defined methods.
 */
public class NilSO extends SerializedPrimitiveSO{

 /** The parent object for this object*/
  protected static LocalOrdinarySO parent = 
    new LocalOrdinarySO(new ParentSlot("parent", dSelfVM.lobbySO));

 /**
  * The slots for this object. It consists of only one slot
  * called "parent"
  */
  protected static SlotVector slotVector = 
    new SlotVector(new ParentSlot("parent",parent));   
    
 /**
  * The parent slots for all this object. It consists of only one slot
  * called "parent"
  */
  protected static Vector parVector = new Vector();   
  
  static{
    parVector.add(parent);   
  }

 /** Creates a new nil object */
  public NilSO(){}
  
 /**
  * Returns the slots of the false object. I.e, it's only one slot
  * called "parent".
  */   
  public SlotVector getSlotVector(){
    
    return slotVector; 
  }
  
 /**
  * Returns the parent slot for the dSelf false object.
  */  
  protected LocalOrdinarySO getParent(){
  
    return parent;
  }
    
 /**
  * Returns the parent slots of the false object. I.e, it's only one 
  * slot called "parent".
  */   
  public Vector getParentVector(){
  
    return parVector;
  }   

 /**
  * Returns the name of this object. 
  */
  public String getName(){
  
    return "nil";
  }
  
 /**
  * Check if the argument is nil.
  *
  * @param arg The argument type must be NilSO and is checked by
  * the method
  */ 
  protected BooleanSO _Eq(dSelfObject so) throws dSelfException{

    if(!(so instanceof NilSO))
      throw new dSelfException("Wrong argument-type send to \"_Eq:\" !"+
          " Nil was expected.", "_Eq:", "badTypeError");

    return new TrueSO();
  }  
}
