package dSelf;

import java.util.Vector;

/**
 * The class PrimMsg represents primitive messages in dSelf. Each 
 * message has an ID 
 */
 
public class PrimMsg extends Message{   

 /**
  * The number of primitives, that are available in dSelf.
  */
  protected static final int numPrim = 233;

 /**
  * The ID for the primitive self. In dSelf self is handled
  * as an primitive message, that is send through all blocks,
  * methods and expressions to the data object, that executes
  * them. 
  */
  public static final int SELF = 0;
    /** The ID for the primitive "_AddSlot:ConnectedTo:" */
  public static final int ADDSLOTCONNECTEDTO= 221; 
    /** The ID for the primitive "_AddSlotIfAbsent:ConnectedTo:" */
  public static final int ADDSLOTIFABSENTCONNECTEDTO= 223; 
   /** The ID for the primitive "_AddSlots:" */
  public static final int ADDSLOTS = 1;
   /** The ID for the primitive "_AddSlotsIfAbsent:" */
  public static final int ADDSLOTSIFABSENT = 2;
   /** The ID for the primitive "_At:" */
  public static final int AT = 3;
   /** The ID for the primitive "_At:Put:" */
  public static final int ATPUT = 4;
   /** The ID for the primitive "_BitSize:" */
  public static final int BITSIZE = 5;
   /** The ID for the primitive "_ByteAt:" */
  public static final int BYTEAT = 6;
   /** The ID for the primitive "_ByteAt:IfFail:" */
  public static final int BYTEATIFFAIL = 7;
   /** The ID for the primitive "_ByteAt:Put:" */
  public static final int BYTEATPUT = 8;
   /** The ID for the primitive "_ByteSize" */
  public static final int BYTESIZE = 9;
   /** The ID for the primitive "_ByteVectorAsString" */
  public static final int BYTEVECTORASSTRING = 10;
   /** The ID for the primitive "_ByteVectorCompare:" */
  public static final int BYTEVECTORCOMPARE = 11;
   /** The ID for the primitive "_ByteVectorConcatenate:" */
  public static final int BYTEVECTORCONCATENATE = 12;
   /** The ID for the primitive "_Clone" */
  public static final int CLONE = 13;
   /** The ID for the primitive "_CloneBytes:Filler:" */
  public static final int CLONEBYTESFILLER = 14;
   /** The ID for the primitive "_Clone:Filler:" */
  public static final int CLONEFILLER = 15;
   /** The ID for the primitive "_CopyByteRangeDstPos:Src:SrcPos:Length:" */
  public static final int COPYBYTERANGEDSTPOSSRCSRCPOSLENGTH = 16;
   /** The ID for the primitive "_CopyRangeDstPos:Src:SrcPos:Length:" */
  public static final int COPYRANGEDSTPOSSRCSRCPOSLENGTH = 17;
   /** The ID for the primitive "_Credits" */
  public static final int CREDITS = 18;
   /** The ID for the primitive "_CurrentTimeString" */
  public static final int CURRENTTIMESTRING = 19;
   /** The ID for the primitive "_Eq:" */
  public static final int EQ = 20;
   /** The ID for the primitive "_DebugCUPOn" */
  public static final int DEBUGCUPON = 21;
   /** The ID for the primitive "_DebugCUPOff" */
  public static final int DEBUGCUPOFF = 22;
   /** The ID for the primitive "_DebugScannerOn" */
  public static final int DEBUGSCANNERON = 23;
   /** The ID for the primitive "_DebugScannerOff" */
  public static final int DEBUGSCANNEROFF = 24;
   /** The ID for the primitive "_DebugFlatParseTreeOn" */
  public static final int DEBUGFLATPARSETREEON = 25;
   /** The ID for the primitive "_DebugFlatParseTreeOff" */
  public static final int DEBUGFLATPARSETREEOFF = 26;
   /** The ID for the primitive "_DebugIndentedParseTreeOn" */
  public static final int DEBUGINDENTEDPARSETREEON = 27;
   /** The ID for the primitive "_DebugIndentedParseTreeOff" */
  public static final int DEBUGINDENTEDPARSETREEOFF = 28;
   /** The ID for the primitive "_DebugLookupCacheOn" */
  public static final int DEBUGLOOKUPCACHEON = 229;
   /** The ID for the primitive "_DebugLookupCacheOff" */
  public static final int DEBUGLOOKUPCACHEOFF = 230;
   /** The ID for the primitive "_DebugSearchPathOn" */
  public static final int DEBUGSEARCHPATHON = 29;
   /** The ID for the primitive "_DebugSearchPathOff" */
  public static final int DEBUGSEARCHPATHOFF = 30;
   /** The ID for the primitive "_Define:" */
  public static final int DEFINE = 222;
   /** The ID for the primitive "_Describe" */
  public static final int DIRPATH1 = 215;
   /** The ID for the primitive "_DirPath" */
  public static final int DIRPATH2 = 216;
   /** The ID for the primitive "_DirPath:" */
  public static final int DESCRIBE = 31;
   /** The ID for the primitive "_DoubleAdd:" */
  public static final int DOUBLEADD = 32;
   /** The ID for the primitive "_DoubleAsFloat" */
  public static final int DOUBLEASFLOAT = 33;
   /** The ID for the primitive "_DoubleAsInt" */
  public static final int DOUBLEASINT = 34;
   /** The ID for the primitive "_DoubleAsLong" */
  public static final int DOUBLEASLONG = 35;
   /** The ID for the primitive "_DoubleAsShort" */
  public static final int DOUBLEASSHORT = 217;
   /** The ID for the primitive "_DoubleCeil" */
  public static final int DOUBLECEIL = 36;
   /** The ID for the primitive "_DoubleDiv:" */
  public static final int DOUBLEDIV = 37;
   /** The ID for the primitive "_DoubleEQ:" */
  public static final int DOUBLEEQ = 38;
   /** The ID for the primitive "_DoubleFloor" */
  public static final int DOUBLEFLOOR = 39;
   /** The ID for the primitive "_DoubleGE:" */
  public static final int DOUBLEGE = 40;
   /** The ID for the primitive "_DoubleGT:" */
  public static final int DOUBLEGT = 41;
   /** The ID for the primitive "_DoubleLE:" */
  public static final int DOUBLELE = 213;
   /** The ID for the primitive "_DoubleLT:" */
  public static final int DOUBLELT = 42;
   /** The ID for the primitive "_DoubleMod:" */
  public static final int DOUBLEMOD = 43;
   /** The ID for the primitive "_DoubleMul:" */
  public static final int DOUBLEMUL = 44;
   /** The ID for the primitive "_DoubleNE:" */
  public static final int DOUBLENE = 45;
   /** The ID for the primitive "_DoublePrintString" */
  public static final int DOUBLEPRINTSTRING = 46;
   /** The ID for the primitive "_DoublePrintStringPrecision:" */
  public static final int DOUBLEPRINTSTRINGPRECISION = 47;
   /** The ID for the primitive "_DoubleRound" */
  public static final int DOUBLEROUND = 48;
   /** The ID for the primitive "_DoubleSub:" */
  public static final int DOUBLESUB = 49;
   /** The ID for the primitive "_DoubleTruncate" */
  public static final int DOUBLETRUNCATE = 50;
   /** The ID for the primitive "_FloatAdd:" */
  public static final int FLOATADD = 51;
   /** The ID for the primitive "_FloatAsDouble" */
  public static final int FLOATASDOUBLE = 52;
   /** The ID for the primitive "_FloatAsInt" */
  public static final int FLOATASINT = 53;
   /** The ID for the primitive "_FloatAsLong" */
  public static final int FLOATASLONG = 54;
   /** The ID for the primitive "_FloatAsShort" */
  public static final int FLOATASSHORT = 219;
   /** The ID for the primitive "_FloatCeil" */
  public static final int FLOATCEIL = 55;
   /** The ID for the primitive "_FloatDiv:" */
  public static final int FLOATDIV = 56;
   /** The ID for the primitive "_FloatEQ:" */
  public static final int FLOATEQ = 57;
   /** The ID for the primitive "_FloatFloor" */
  public static final int FLOATFLOOR = 58;
   /** The ID for the primitive "_FloatGE:" */
  public static final int FLOATGE = 59;
   /** The ID for the primitive "_FloatGT:" */
  public static final int FLOATGT = 60;
   /** The ID for the primitive "_FloatLE:" */
  public static final int FLOATLE = 61;
   /** The ID for the primitive "_FloatLT:" */
  public static final int FLOATLT = 62;
   /** The ID for the primitive "_FloatMod:" */
  public static final int FLOATMOD = 63;
   /** The ID for the primitive "_FloatMul:" */
  public static final int FLOATMUL = 64;
   /** The ID for the primitive "_FloatNE:" */
  public static final int FLOATNE = 65;
   /** The ID for the primitive "_FloatPrintString" */
  public static final int FLOATPRINTSTRING = 66;
   /** The ID for the primitive "_FloatPrintStringPrecision:" */
  public static final int FLOATPRINTSTRINGPRECISION = 67;
   /** The ID for the primitive "_FloatRound" */
  public static final int FLOATROUND = 68;
   /** The ID for the primitive "_FloatSub:" */
  public static final int FLOATSUB = 69;
   /** The ID for the primitive "_FloatTruncate" */
  public static final int FLOATTRUNCATE = 70;
   /** The ID for the primitive "_FreeMemory" */
  public static final int FREEMEMORY = 232;
   /** The ID for the primitive "_GarbageCollect" */
  public static final int GARBAGECOLLECT = 71;
   /** The ID for the primitive "_Genes" */
  public static final int GENES = 231;
   /** The ID for the primitive "_GetLocation" */
  public static final int GETLOCATION = 227;
   /** The ID for the primitive "_GetSlotNames" */
  public static final int GETSLOTNAMES = 224;
   /** The ID for the primitive "_IntAdd:" */
  public static final int INTADD = 72;
   /** The ID for the primitive "_IntAnd:" */
  public static final int INTAND = 73;
   /** The ID for the primitive "_IntArithmeticShiftRight:" */
  public static final int INTARITHMETICSHIFTRIGHT = 74;
   /** The ID for the primitive "_IntAsDouble" */
  public static final int INTASDOUBLE = 75;
   /** The ID for the primitive "_IntAsFloat" */
  public static final int INTASFLOAT = 76;
   /** The ID for the primitive "_IntAsLong" */
  public static final int INTASLONG = 77;
   /** The ID for the primitive "_IntAsShort" */
  public static final int INTASSHORT = 218;
   /** The ID for the primitive "_IntDiv:" */
  public static final int INTDIV = 78;
   /** The ID for the primitive "_IntEQ:" */
  public static final int INTEQ = 79;
   /** The ID for the primitive "_IntGE:" */
  public static final int INTGE = 80;
   /** The ID for the primitive "_IntGT" */
  public static final int INTGT = 81;
   /** The ID for the primitive "_IntLE:" */
  public static final int INTLE = 82;
   /** The ID for the primitive "_IntLT:" */
  public static final int INTLT = 83;
   /** The ID for the primitive "_IntLogicalShiftLeft:" */
  public static final int INTLOGICALSHIFTLEFT = 84;
   /** The ID for the primitive "_IntLogicalShiftRight:" */
  public static final int INTLOGICALSHIFTRIGHT = 85;
   /** The ID for the primitive "_IntMod:" */
  public static final int INTMOD = 86;
   /** The ID for the primitive "_IntMul:" */
  public static final int INTMUL = 87;
   /** The ID for the primitive "_IntNE:" */
  public static final int INTNE = 88;
   /** The ID for the primitive "_IntOr:" */
  public static final int INTOR = 89;
   /** The ID for the primitive "_IntSub:" */
  public static final int INTSUB = 90;
   /** The ID for the primitive "_IntXor:" */
  public static final int INTXOR = 91;
   /** The ID for the primitive "_Lock" */
  public static final int LOCK = 225;
   /** The ID for the primitive "_LongAdd:" */
  public static final int LONGADD = 92;
   /** The ID for the primitive "_LongAnd:" */
  public static final int LONGAND = 93;
   /** The ID for the primitive "_LongArithmeticShiftRight:" */
  public static final int LONGARITHMETICSHIFTRIGHT = 94;
   /** The ID for the primitive "_LongAsDouble" */
  public static final int LONGASDOUBLE = 95;
   /** The ID for the primitive "_LongAsFloat" */
  public static final int LONGASFLOAT = 96;
   /** The ID for the primitive "_LongAsInt" */
  public static final int LONGASINT = 97;
   /** The ID for the primitive "_LongAsShort" */
  public static final int LONGASSHORT = 220;
   /** The ID for the primitive "_LongDiv:" */
  public static final int LONGDIV = 98;
   /** The ID for the primitive "_LongEQ:" */
  public static final int LONGEQ = 99;
   /** The ID for the primitive "_LongGE:" */
  public static final int LONGGE = 100;
   /** The ID for the primitive "_LongGT" */
  public static final int LONGGT = 101;
   /** The ID for the primitive "_LongLE:" */
  public static final int LONGLE = 102;
   /** The ID for the primitive "_LongLT:" */
  public static final int LONGLT = 103;
   /** The ID for the primitive "_LongLogicalShiftLeft:" */
  public static final int LONGLOGICALSHIFTLEFT = 104;
   /** The ID for the primitive "_LongLogicalShiftRight:" */
  public static final int LONGLOGICALSHIFTRIGHT = 105;
   /** The ID for the primitive "_LongMod:" */
  public static final int LONGMOD = 106;
   /** The ID for the primitive "_LongMul:" */
  public static final int LONGMUL = 107;
   /** The ID for the primitive "_LongNE:" */
  public static final int LONGNE = 108;
   /** The ID for the primitive "_LongOr:" */
  public static final int LONGOR = 109;
   /** The ID for the primitive "_LongSub:" */
  public static final int LONGSUB = 110;
   /** The ID for the primitive "_LongXor:" */
  public static final int LONGXOR = 111;
   /** The ID for the primitive "_Loop" */
  public static final int LOOP = 228;
   /** The ID for the primitive "_Memory" */
  public static final int MEMORY = 112;
   /** The ID for the primitive "_ObjectID" */
  public static final int OBJECTID = 113;
   /** The ID for the primitive "_OperatingSystem" */
  public static final int OPERATINGSYSTEM = 114;
   /** The ID for the primitive "_Quit" */
  public static final int QUIT = 115;
   /** The ID for the primitive "_Perform:" */
  public static final int PERFORM = 116;
   /** The ID for the primitive "_Perform:With:" */
  public static final int PERFORMWITH1 = 117;
   /** The ID for the primitive "_Perform:With:With:" */
  public static final int PERFORMWITH2 = 118;
   /** The ID for the primitive "_Perform:With:With:With:" */
  public static final int PERFORMWITH3 = 119;
   /** The ID for the primitive "_Perform:With:With:With:With:" */
  public static final int PERFORMWITH4 = 120;
   /** The ID for the primitive "_Perform:With:With:With:With:With:" */
  public static final int PERFORMWITH5 = 121;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:" */
  public static final int PERFORMWITH6 = 122;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH7 = 123;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH8 = 124;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH9 = 125;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH10 = 126;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH11 = 127;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH12 = 128;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH13 = 129;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH14 = 130;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH15 = 131;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH16 = 132;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH17 = 133;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH18 = 134;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH19 = 135;
   /** The ID for the primitive "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMWITH20 = 136;
   /** The ID for the primitive "_PerformResend:" */
  public static final int PERFORMRESEND = 137;
   /** The ID for the primitive "_PerformResend:With:" */
  public static final int PERFORMRESENDWITH1 = 138;
   /** The ID for the primitive "_PerformResend:With:With:" */
  public static final int PERFORMRESENDWITH2 = 139;
   /** The ID for the primitive "_PerformResend:With:With:With:" */
  public static final int PERFORMRESENDWITH3 = 140;
   /** The ID for the primitive "_PerformResend:With:With:With:With:" */
  public static final int PERFORMRESENDWITH4 = 141;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH5 = 142;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH6 = 143;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH7 = 144;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH8 = 145;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH9 = 146;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH10 = 147;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH11 = 148;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH12 = 149;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH13 = 150;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH14 = 151;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH15 = 152;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH16 = 153;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH17 = 154;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH18 = 155;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH19 = 156;
   /** The ID for the primitive "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMRESENDWITH20 = 157;
   /** The ID for the primitive "_Perform:DelegatingTo:" */
  public static final int PERFORMDELEGATINGTO = 158;
   /** The ID for the primitive "_Perform:DelegatingTo:With:" */
  public static final int PERFORMDELEGATINGTOWITH1 = 160;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH2 = 161;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH3 = 162;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH4 = 163;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH5 = 164;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH6 = 165;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH7 = 166;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH8 = 167;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH9 = 168;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH10 = 169;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH11 = 170;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH12 = 171;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH13 = 172;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH14 = 173;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH15 = 174;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH16 = 175;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH17 = 176;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH18 = 177;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH19 = 178;
   /** The ID for the primitive "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:" */
  public static final int PERFORMDELEGATINGTOWITH20 = 179;
   /** The ID for the primitive "_Print" */
  public static final int PRINT = 180;
   /** The ID for the primitive "_RemoveAllSlots" */
  public static final int REMOVEALLSLOTS = 181;
   /** The ID for the primitive "_RemoveSlot:" */
  public static final int REMOVESLOT = 182;
   /** The ID for the primitive "_RunScript" */
  public static final int RUNSCRIPT = 214;
   /** The ID for the primitive "_ShortAdd:" */
  public static final int SHORTADD = 183;
   /** The ID for the primitive "_ShortAnd:" */
  public static final int SHORTAND = 184;
   /** The ID for the primitive "_ShortArithmeticShiftRight:" */
  public static final int SHORTARITHMETICSHIFTRIGHT = 185;
   /** The ID for the primitive "_ShortAsDouble" */
  public static final int SHORTASDOUBLE = 186;
   /** The ID for the primitive "_ShortAsFloat" */
  public static final int SHORTASFLOAT = 187;
   /** The ID for the primitive "_ShortAsInt" */
  public static final int SHORTASINT = 188;
   /** The ID for the primitive "_ShortAsLong" */
  public static final int SHORTASLONG = 189;
   /** The ID for the primitive "_ShortDiv:" */
  public static final int SHORTDIV = 190;
   /** The ID for the primitive "_ShortEQ:" */
  public static final int SHORTEQ = 191;
   /** The ID for the primitive "_ShortGE:" */
  public static final int SHORTGE = 192;
   /** The ID for the primitive "_ShortGT" */
  public static final int SHORTGT = 193;
   /** The ID for the primitive "_ShortLE:" */
  public static final int SHORTLE = 194;
   /** The ID for the primitive "_ShortLT:" */
  public static final int SHORTLT = 195;
   /** The ID for the primitive "_ShortLogicalShiftLeft:" */
  public static final int SHORTLOGICALSHIFTLEFT = 196;
   /** The ID for the primitive "_ShortLogicalShiftRight:" */
  public static final int SHORTLOGICALSHIFTRIGHT = 197;
   /** The ID for the primitive "_ShortMod:" */
  public static final int SHORTMOD = 198;
   /** The ID for the primitive "_ShortMul:" */
  public static final int SHORTMUL = 199;
   /** The ID for the primitive "_ShortNE:" */
  public static final int SHORTNE = 200;
   /** The ID for the primitive "_ShortOr:" */
  public static final int SHORTOR = 201;
   /** The ID for the primitive "_ShortSub:" */
  public static final int SHORTSUB = 202;
   /** The ID for the primitive "_ShortXor:" */
  public static final int SHORTXOR = 203;
   /** The ID for the primitive "_Size" */
  public static final int SIZE = 204;
   /** The ID for the primitive "_StringAsByteVector" */
  public static final int STRINGASBYTEVECTOR = 205;
   /** The ID for the primitive "_StringAt:" */
  public static final int STRINGAT = 206;
   /** The ID for the primitive "_StringConcatenate:" */
  public static final int STRINGCONCATENATE = 207;
   /** The ID for the primitive "_StringSize" */
  public static final int STRINGSIZE = 208;
   /** The ID for the primitive "_StringGetSubFrom:" */
  public static final int STRINGGETSUBFROM = 209;
   /** The ID for the primitive "_StringGetSubFrom:To:" */
  public static final int STRINGGETSUBFROMTO = 210;
   /** The ID for the primitive "_StringPrint" */
  public static final int STRINGPRINT = 211;
   /** The ID for the primitive "_TimeReal" */
  public static final int TIMEREAL = 212;
   /** The ID for the primitive "_Unlock" */
  public static final int UNLOCK = 226;

/** 
  * An array, that conists of the names of the primitives.
  * Their index correspond to their ID
  */
  protected static String[] primTable = new String[numPrim];
  
  static{
    primTable[SELF] = "self";
    primTable[ADDSLOTCONNECTEDTO] = "_AddSlot:ConnectedTo:";
    primTable[ADDSLOTIFABSENTCONNECTEDTO] = "_AddSlotIfAbsent:ConnectedTo:";
    primTable[ADDSLOTS] = "_AddSlots:";
    primTable[ADDSLOTSIFABSENT] = "_AddSlotsIfAbsent:";
    primTable[AT] = "_At:";
    primTable[ATPUT] = "_At:Put:";
    primTable[BITSIZE] = "_BitSize";
    primTable[BYTEAT] = "_ByteAt:";
    primTable[BYTEAT] = "_ByteAt:";
    primTable[BYTEATIFFAIL] = "_ByteAt:IfFail:";
    primTable[BYTEATPUT] = "_ByteAt:Put:";
    primTable[BYTESIZE] = "_ByteSize";
    primTable[BYTEVECTORASSTRING] = "_ByteVectorAsString";
    primTable[BYTEVECTORCOMPARE] = "_ByteVectorCompare:";
    primTable[BYTEVECTORCONCATENATE] = "_ByteVectorConcatenate:";
    primTable[CLONE] = "_Clone";
    primTable[CLONEBYTESFILLER] = "_CloneBytes:Filler:";
    primTable[CLONEFILLER] = "_Clone:Filler:";
    primTable[COPYBYTERANGEDSTPOSSRCSRCPOSLENGTH] = "_CopyByteRangeDstPos:Src:SrcPos:Length:";
    primTable[COPYRANGEDSTPOSSRCSRCPOSLENGTH] = "_CopyRangeDstPos:Src:SrcPos:Length:";
    primTable[CREDITS] = "_Credits";
    primTable[CURRENTTIMESTRING] = "_CurrentTimeString";
    primTable[EQ] = "_Eq:";
    primTable[DEBUGCUPON] = "_DebugCUPOn";
    primTable[DEBUGCUPOFF] = "_DebugCUPOff";
    primTable[DEBUGSCANNERON] = "_DebugScannerOn";
    primTable[DEBUGSCANNEROFF] = "_DebugScannerOff";
    primTable[DEBUGSEARCHPATHON] = "_DebugSearchPathOn";
    primTable[DEBUGSEARCHPATHOFF] = "_DebugSearchPathOff";
    primTable[DEBUGLOOKUPCACHEON] = "_DebugLookupCacheOn";
    primTable[DEBUGLOOKUPCACHEOFF] = "_DebugLookupCacheOff";
    primTable[DEBUGFLATPARSETREEON] = "_DebugFlatParseTreeOn";
    primTable[DEBUGFLATPARSETREEOFF] = "_DebugFlatParseTreeOff";
    primTable[DEBUGINDENTEDPARSETREEON] = "_DebugIndentedParseTreeOn";
    primTable[DEBUGINDENTEDPARSETREEOFF] = "_DebugIndentedParseTreeOff";
    primTable[DEFINE] = "_Define:";
    primTable[DESCRIBE] = "_Describe";
    primTable[DIRPATH1] = "_DirPath";
    primTable[DIRPATH2] = "_DirPath:";
    primTable[DOUBLEADD] = "_DoubleAdd:";
    primTable[DOUBLEASFLOAT] = "_DoubleAsFloat";
    primTable[DOUBLEASINT] = "_DoubleAsInt";
    primTable[DOUBLEASLONG] = "_DoubleAsLong";
    primTable[DOUBLEASSHORT] = "_DoubleAsShort";
    primTable[DOUBLECEIL] = "_DoubleCeil";
    primTable[DOUBLEDIV] = "_DoubleDiv:";
    primTable[DOUBLEEQ] = "_DoubleEQ:";
    primTable[DOUBLEFLOOR] = "_DoubleFloor";
    primTable[DOUBLEGE] = "_DoubleGE:";
    primTable[DOUBLEGT] = "_DoubleGT:";
    primTable[DOUBLELE] = "_DoubleLE:";
    primTable[DOUBLELT] = "_DoubleLT:";
    primTable[DOUBLEMOD] = "_DoubleMod:";
    primTable[DOUBLEMUL] = "_DoubleMul:";
    primTable[DOUBLENE] = "_DoubleNE:";
    primTable[DOUBLEPRINTSTRING] = "_DoublePrintString";
    primTable[DOUBLEPRINTSTRINGPRECISION] = "_DoublePrintStringPrecision:";
    primTable[DOUBLEROUND] = "_DoubleRound";
    primTable[DOUBLESUB] = "_DoubleSub:";
    primTable[DOUBLETRUNCATE] = "_DoubleTruncate";
    primTable[FLOATADD] = "_FloatAdd:";
    primTable[FLOATASDOUBLE] = "_FloatAsDouble";
    primTable[FLOATASINT] = "_FloatAsInt";
    primTable[FLOATASLONG] = "_FloatAsLong";
    primTable[FLOATASSHORT] = "_FloatAsShort";
    primTable[FLOATCEIL] = "_FloatCeil";
    primTable[FLOATDIV] = "_FloatDiv:";
    primTable[FLOATEQ] = "_FloatEQ:";
    primTable[FLOATFLOOR] = "_FloatFloor";
    primTable[FLOATGE] = "_FloatGE:";
    primTable[FLOATGT] = "_FloatGT:";
    primTable[FLOATLE] = "_FloatLE:";
    primTable[FLOATLT] = "_FloatLT:";
    primTable[FLOATMOD] = "_FloatMod:";
    primTable[FLOATMUL] = "_FloatMul:";
    primTable[FLOATNE] = "_FloatNE:";
    primTable[FLOATPRINTSTRING] = "_FloatPrintString";
    primTable[FLOATPRINTSTRINGPRECISION] = "_FloatPrintStringPrecision:";
    primTable[FLOATROUND] = "_FloatRound";
    primTable[FLOATSUB] = "_FloatSub:";
    primTable[FLOATTRUNCATE] = "_FloatTruncate";
    primTable[FREEMEMORY] = "_FreeMemory";
    primTable[GARBAGECOLLECT] = "_GarbageCollect";
    primTable[GENES] = "_Genes";
    primTable[GETSLOTNAMES] = "_GetSlotNames";
    primTable[GETLOCATION] = "_GetLocation";
    primTable[INTADD] = "_IntAdd:";
    primTable[INTAND] = "_IntAnd:";
    primTable[INTARITHMETICSHIFTRIGHT] = "_IntArithmeticShiftRight:";
    primTable[INTASDOUBLE] = "_IntAsDouble";
    primTable[INTASFLOAT] = "_IntAsFloat";
    primTable[INTASLONG] = "_IntAsLong";
    primTable[INTASSHORT] = "_IntAsShort";
    primTable[INTDIV] = "_IntDiv:";
    primTable[INTEQ] = "_IntEQ:";
    primTable[INTGE] = "_IntGE:";
    primTable[INTGT] = "_IntGT:";
    primTable[INTLE] = "_IntLE:";
    primTable[INTLT] = "_IntLT:";
    primTable[INTLOGICALSHIFTLEFT] = "_IntLogicalShiftLeft:";
    primTable[INTLOGICALSHIFTRIGHT] = "_IntLogicalShiftRight:";
    primTable[INTMOD] = "_IntMod:";
    primTable[INTMUL] = "_IntMul:";
    primTable[INTNE] = "_IntNE:";
    primTable[INTOR] = "_IntOr:";
    primTable[INTSUB] = "_IntSub:";
    primTable[INTXOR] = "_IntXor:";
    primTable[LONGADD] = "_LongAdd:";
    primTable[LONGAND] = "_LongAnd:";
    primTable[LONGARITHMETICSHIFTRIGHT] = "_LongArithmeticShiftRight:";
    primTable[LONGASDOUBLE] = "_LongAsDouble";
    primTable[LONGASFLOAT] = "_LongAsFloat";
    primTable[LONGASINT] = "_LongAsInt";
    primTable[LONGASSHORT] = "_LongAsShort";
    primTable[LONGDIV] = "_LongDiv:";
    primTable[LONGEQ] = "_LongEQ:";
    primTable[LONGGE] = "_LongGE:";
    primTable[LONGGT] = "_LongGT:";
    primTable[LONGLE] = "_LongLE:";
    primTable[LONGLT] = "_LongLT:";
    primTable[LONGLOGICALSHIFTLEFT] = "_LongLogicalShiftLeft:";
    primTable[LONGLOGICALSHIFTRIGHT] = "_LongLogicalShiftRight:";
    primTable[LONGMOD] = "_LongMod:";
    primTable[LONGMUL] = "_LongMul:";
    primTable[LONGNE] = "_LongNE:";
    primTable[LONGOR] = "_LongOr:";
    primTable[LONGSUB] = "_LongSub:";
    primTable[LONGXOR] = "_LongXor:";
    primTable[LOOP] = "_Loop";
    primTable[MEMORY] = "_Memory";
    primTable[OBJECTID] = "_ObjectID";
    primTable[OPERATINGSYSTEM] = "_OperatingSystem";
    primTable[QUIT] = "_Quit";
    primTable[LOCK] = "_Lock:";
    primTable[PERFORM] = "_Perform:";
    primTable[PERFORMWITH1] = "_Perform:With:";
    primTable[PERFORMWITH2] = "_Perform:With:With:";
    primTable[PERFORMWITH3] = "_Perform:With:With:With:";
    primTable[PERFORMWITH4] = "_Perform:With:With:With:With:";
    primTable[PERFORMWITH5] = "_Perform:With:With:With:With:With:";
    primTable[PERFORMWITH6] = "_Perform:With:With:With:With:With:With:";
    primTable[PERFORMWITH7] = "_Perform:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH8] = "_Perform:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH9] = "_Perform:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH10] = "_Perform:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH11] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH12] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH13] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH14] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH15] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH16] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH17] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH18] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH19] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMWITH20] = "_Perform:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESEND] = "_PerformResend:";
    primTable[PERFORMRESENDWITH1] = "_PerformResend:With:";
    primTable[PERFORMRESENDWITH2] = "_PerformResend:With:With:";
    primTable[PERFORMRESENDWITH3] = "_PerformResend:With:With:With:";
    primTable[PERFORMRESENDWITH4] = "_PerformResend:With:With:With:With:";
    primTable[PERFORMRESENDWITH5] = "_PerformResend:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH6] = "_PerformResend:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH7] = "_PerformResend:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH8] = "_PerformResend:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH9] = "_PerformResend:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH10] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH11] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH12] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH13] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH14] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH15] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH16] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH17] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH18] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH19] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMRESENDWITH20] = "_PerformResend:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTO] = "_Perform:DelegatingTo:";
    primTable[PERFORMDELEGATINGTOWITH1] = "_Perform:DelegatingTo:With:";
    primTable[PERFORMDELEGATINGTOWITH2] = "_Perform:DelegatingTo:With:With:";
    primTable[PERFORMDELEGATINGTOWITH3] = "_Perform:DelegatingTo:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH4] = "_Perform:DelegatingTo:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH5] = "_Perform:DelegatingTo:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH6] = "_Perform:DelegatingTo:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH7] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH8] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH9] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH10] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH11] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH12] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH13] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH14] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH15] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH16] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH17] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH18] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH19] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PERFORMDELEGATINGTOWITH20] = "_Perform:DelegatingTo:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:With:";
    primTable[PRINT] = "_Print";
    primTable[REMOVEALLSLOTS] = "_RemoveAllSlots";
    primTable[REMOVESLOT] = "_RemoveSlot:";
    primTable[RUNSCRIPT] = "_RunScript";
    primTable[SHORTADD] = "_ShortAdd:";
    primTable[SHORTAND] = "_ShortAnd:";
    primTable[SHORTARITHMETICSHIFTRIGHT] = "_ShortArithmeticShiftRight:";
    primTable[SHORTASDOUBLE] = "_ShortAsDouble";
    primTable[SHORTASFLOAT] = "_ShortAsFloat";
    primTable[SHORTASINT] = "_ShortAsInt";
    primTable[SHORTASLONG] = "_ShortAsLong";
    primTable[SHORTDIV] = "_ShortDiv:";
    primTable[SHORTEQ] = "_ShortEQ:";
    primTable[SHORTGE] = "_ShortGE:";
    primTable[SHORTGT] = "_ShortGT:";
    primTable[SHORTLE] = "_ShortLE:";
    primTable[SHORTLT] = "_ShortLT:";
    primTable[SHORTLOGICALSHIFTLEFT] = "_ShortLogicalShiftLeft:";
    primTable[SHORTLOGICALSHIFTRIGHT] = "_ShortLogicalShiftRight:";
    primTable[SHORTMOD] = "_ShortMod:";
    primTable[SHORTMUL] = "_ShortMul:";
    primTable[SHORTNE] = "_ShortNE:";
    primTable[SHORTOR] = "_ShortOr:";
    primTable[SHORTSUB] = "_ShortSub:";
    primTable[SHORTXOR] = "_ShortXor:";
    primTable[SIZE] = "_Size";
    primTable[STRINGASBYTEVECTOR] = "_StringAsByteVector";
    primTable[STRINGAT] = "_StringAt:";
    primTable[STRINGCONCATENATE] = "_StringConcatenate:";
    primTable[STRINGSIZE] = "_StringSize";
    primTable[STRINGGETSUBFROM] = "_StringGetSubFrom:";
    primTable[STRINGGETSUBFROMTO] = "_StringGetSubFrom:To:";
    primTable[STRINGPRINT] = "_StringPrint";
    primTable[TIMEREAL] = "_TimeReal";
    primTable[UNLOCK] = "_Unlock:";
    
  }

 /**
  * Coverts a given string, which contains the name of
  * primitive into an ID. 
  *
  * @param primString The name of the primitive message.
  * @return The ID that correspondes to the given name. When
  * When the string isn't a proper primitive name, -1 is returned.
  */ 
  public static int stringToPrimID(String primString){

    for(int i=0;i<numPrim;i++)
      if(primString.equals(primTable[i]) || 
         primString.equals(primTable[i] + "IfFail:"))
        return i;

    return -1;
  }  

 /**
  * Check, whether a given primitive message has a trailing "IfFail:" 
  * part. 
  *
  * @param primString The name of the primitive message.
  * @return true, if it ends with "IfFail:" and false when not.
  */
  public static boolean hasFailBlock(String primString){
  
    return primString.endsWith("IfFail:");
  }
  
 /**
  * Converts a given ID to its corresponding name as a string.
  *
  * @param ID An integer that represents the ID.
  * @return The name of the message as a string.
  */   
  public static String primIDToString(int ID){

    try{
      return primTable[ID];
    }catch(ArrayIndexOutOfBoundsException e){
      return "";
    }  
  }

 /**
  * The ID of this primitive message.
  */
  protected int primID;
  
 /**
  * Has this message a fail block ?
  */ 
  protected boolean hasFailBlock = false;
  
 /**
  * Construct a new message with the given ID.
  *
  * @param ID An integer that represents the ID.
  */ 
  public PrimMsg(int ID){

    primID = ID;
  }

 /**
  * Construct a new primitive message object with the given ID. 
  *
  * @param ID An integer that represents the ID.
  * @param hasFail Specifies, if it has a fail block.
  */ 
  public PrimMsg(int ID, boolean hasFail){

    primID = ID;
    hasFailBlock = hasFail;
  }

 /**
  * Construct a new primitive message object with the given ID. 
  *
  * @param ID An integer that represents the ID.
  * @param args A vector with the arguments of this message.
  */ 
  public PrimMsg(int ID, Vector args){

    this(ID);
    messageArguments = args;
  }
  
 /**
  * Construct a new primitive message object with the given ID. 
  *
  * @param ID An integer that represents the ID.
  * @param hasFail Specifies, if it has a fail block.
  * @param args A vector with the arguments of this message.
  */ 
  public PrimMsg(int ID, boolean hasFail, Vector args){

    this(ID);
    messageArguments = args;
    hasFailBlock = hasFail;
  }

 /**
  * Check, if this message has a fail block.
  */ 
  public boolean hasFailBlock(){
  
    return hasFailBlock;
  }
  
 /**
  * Get the ID of this message.
  */   
  public int getMessageID(){
  
    return primID;
  }

 /**
  * Get the selector of this message. In case of primitives, it
  * is the name in the array of strings, with the ID as the index.
  */
  public String getSelector(){
  
    return primTable[primID];
  }  
  
 /**
  * Check, if this message was resended directed or indirected. 
  * For primitives the answer is always no (false), because they 
  * can't be resended.
  */ 
  public boolean isResend(){
  
    return false;
  }  
  
 /**
  * Check, if this message was resended directed. 
  * For primitives the answer is always no (false), because they 
  * can't be resended.
  */ 
  public boolean isDirectedResend(){
  
    return false;
  }  

 /**
  * Check, if this message was resended indirected. 
  * For primitives the answer is always no (false), because they 
  * can't be resended.
  */ 
  public boolean isIndirectedResend(){
  
    return false;
  }  
}
