package dSelf;

import java.util.Vector; 

/**
 * OrdinaryMsgExpr represents the expressions of primitive messages in 
 * dSelf ({@link PrimMsg}). 
 */
public class PrimMsgExpr extends MessageExpr{   
  
  /** The ID of the primitive message. */ 
  protected int primID;
  
  /** Has this object a fail-block ? */
  protected boolean hasFailBlock = false;

 /**
  * Creates a new primitive message expression, that is send to the 
  * receiver, that is given as the first argument. The ID of this 
  * message is given as the second argument. 
  *
  * @param rec The receiver of the message
  * @param ID The ID of this message
  */ 
  public PrimMsgExpr(CodeExpr rec, int ID){
  
    receiver = rec;
    primID = ID;
  }  

 /**
  * Creates a new primitive message expression, that is send to the 
  * receiver, that is given as the first argument. The ID of this 
  * message is given as the second argument.
  *
  * @param rec The receiver of the message
  * @param ID The ID of this message
  * @param fail Has this message a fail-block ?
  */ 
  public PrimMsgExpr(CodeExpr rec, int ID, boolean fail){
  
    this(rec, ID);
    hasFailBlock = fail;
  }  

 /**
  * Creates a new primitive message expression with one argument, that 
  * is send to the receiver, that is given as the first argument. The 
  * ID of this message is given as the second argument. 
  *
  * @param rec The receiver of the message
  * @param ID The ID of this message
  * @param arg The argument for the message
  */ 
  public PrimMsgExpr(CodeExpr rec, int ID, CodeExpr arg){
  
    this(rec, ID);
    methodArguments.add(arg);
  }  
    
 /**
  * Creates a new primitive message expression with one argument, that 
  * is send to the receiver, that is given as the first argument. The 
  * ID of this message is given as the second argument. 
  *
  * @param rec The receiver of the message
  * @param ID The ID of this message
  * @param arg The argument for the message
  * @param fail Has this message a fail-block ?
  */ 
  public PrimMsgExpr(CodeExpr rec, int ID, CodeExpr arg, boolean fail){
  
    this(rec, ID, fail);
    methodArguments.add(arg);
  }  

 /**
  * Creates a new primitive message expression with some arguments, that 
  * is send to the receiver, that is given as the first argument. The 
  * ID of this message is given as the second argument. 
  *
  * @param rec The receiver of the message
  * @param ID The ID of this message
  * @param args The arguments for the message
  */ 
  public PrimMsgExpr(CodeExpr rec, int ID, Vector args){
  
    this(rec, ID);
    methodArguments = args;  
  }  

 /**
  * Creates a new primitive message expression with some arguments, that 
  * is send to the receiver, that is given as the first argument. The 
  * ID of this message is given as the second argument. 
  *
  * @param rec The receiver of the message
  * @param ID The ID of this message
  * @param args The arguments for the message
  * @param fail Has this message a fail-block ?
  */ 
  public PrimMsgExpr(CodeExpr rec, int ID, Vector args, boolean fail){
  
    this(rec, ID, fail);
    methodArguments = args;  
  }  

 /** 
  * Creates a new primitive message object, that represents the evaluated 
  * form of this primitive message expression.
  *
  * @param dSOVec A vector with the arguments of this message
  * @return The new created message
  */
  protected Message createMessage(Vector dSOVec){

    return new PrimMsg(primID, hasFailBlock, dSOVec);
  }
}
