package dSelf;

import java.rmi.*;
import dSelfVM;

/**
 * RemoteObjectVectorSO represents an object vector, that is
 * located on another virtual machine. It realizes a remote reference
 * to this object vector and forwards all messages to it.
 */
public class RemoteObjectVectorSO extends ObjectVectorSO{

  /** The server of the remote dSelf virtual machine. */
  protected ServerInterface remoteVM = null;

 /** 
  * The ID of the remote object vector, that is registered
  * at the remote server.
  */
  protected int remoteID;

 /**
  * Creates a new reference to a remote object vector.
  *
  * @param vm The server of the remote dSelf virtual machine
  * @param ID The ID of the remote object vector, that is registered
  * at the remote server 
  */ 
  public RemoteObjectVectorSO(ServerInterface vm, int ID){

    remoteVM = vm;
    remoteID = ID;
  }

 /**
  * When this object is removed, it removes its corresponding reference
  * at the server of the remote dSelf virtual machine.
  */
  protected void finalize() throws RemoteException{

    remoteVM.removeRemoteReference(remoteID);
  }

 /**
  * Returns the object at the specified position.
  *
  * @param pos The index of the demanded object
  * @return The object at the specified position
  */
  public void putObjectAt(int pos, DataSO arg) 
      throws ArrayIndexOutOfBoundsException{

    SerializedSO serObject = null;
    
    // If the found object is an ordinary object, then we create
    // a reference to it send a SerializedOrdinarySO.
    if(arg instanceof OrdinarySO){
      serObject = new SerializedOrdinarySO(
          dSelfVM.server.addRemoteReference((RemoteReferenceSO)arg));
    }else if(arg instanceof ObjectVectorSO){
      // If the found object is an ordinary object, then we create
      // a reference to it send a SerializedObjectVectorSO.
      serObject = new SerializedObjectVectorSO(
          dSelfVM.server.addRemoteReference((RemoteReferenceSO)arg));
    }else{
      // If it isn't an ordinary object or an object vector, it must be
      // a primitive object that can be serialized.
      serObject = (SerializedSO)arg;  
    }     
    
    try{
      remoteVM.putObjectOfObjectVector(remoteID, dSelfVM.VMName, pos, serObject); 
    }catch(Exception e){
      //throw handleRMIException(e);
      System.out.println(e);
    }    
  }

 /**
  * Returns the length of this object vector. 
  */
  public int getLength(){
  
    try{
      return remoteVM.getLengthOfObjectVector(remoteID);
    }catch(Exception e){
      handleException(e);
    }   
    return -1; 
  }

 /**
  * Puts an object at the specified position.
  *
  * @param pos The index, where this object is put
  * @param arg The object, that is put at the specified position
  */
  public DataSO getObjectAt(int pos) throws ArrayIndexOutOfBoundsException{
  
    SerializedSO result = null;

    // Get the content of a remote object vector. If the content is 
    // serializable, then this object is returned, otherwise a reference 
    // to the remote object has been created at the remote VM.    
    try{
      result = remoteVM.getObjectOfObjectVector(remoteID, pos);
    }catch(Exception e){
      //throw handleRMIException(e);
      System.out.println(e);
    }    
    
    // The remote object is an OrdinarySO, so return the reference to it
    if(result instanceof SerializedOrdinarySO)
      return new RemoteOrdinarySO(remoteVM, ((SerializedOrdinarySO)result).getID());
				      
    return (DataSO) result;
  }
  
}
