package dSelf;

/**
 * SerializedMethodSO repesents the serialized version of a dSelf 
 * method object.
 */
public class SerializedMethodSO implements SerializedSO{

  /** The serialized slots of the method object. */
  protected SerializedSlotVector slots;
  
  /** The code of the method object. */
  protected ExprList expressions;
  
 /**
  * Creates a new serialized method object with the given 
  *
  * @param method The method, that shall be serialized
  * @param server The server, that will send the slot vector
  */ 
  public SerializedMethodSO(MethodSO method, Server server){
  
    slots = new SerializedSlotVector(method.getSlotVector(), server);
    expressions = method.getExpressionList();
  }
  
 /**
  * Returns the method, that was serialized.
  *
  * @param remoteVM The server of the dSelf VM, that received this 
  * slot vector.
  */   
  public MethodSO getMethod(ServerInterface remoteVM){
  
    return new MethodSO(slots.getSlotVector(remoteVM), expressions);
  }
}
