package dSelf;

import java.util.Vector;

/**
 * Slot is the base class for all kind of slots in dSelf. It provides
 * interfaces for returning its content and handling for slot annotations
 */
public interface Slot{

  
  /** Returns the content of this slot */
  public abstract dSelfObject getContent();

  /** Returns the name of this slot */
  public abstract String getName();
  
 /** 
  * Sets a new annotation for this slot. If an old annotation already
  * exists, then the new one is appended to the old one.
  */
  public abstract void setAnnotation(String a);
 
 /**
  * Returns the annotation for this slot. If no annotation exists, then
  * "No annotation available." is returned.
  */   
  public abstract String getAnnotation();
}
