package dSelf;

import java.util.Vector;
import java.io.Serializable;

/**
 * SlottedSOExpr consists of slots, that are initialized with {@link #evalSlots}.
 * It is used by {@link OrdinarySOExpr} and {@link MethodSOExpr}.
 */
public abstract class SlottedSOExpr implements Serializable{

  /** The slot declarations of this object. */
  protected SlotDeclarations slotDeclarations = new SlotDeclarations();
  
 /**
  * Evaluates the slots of this object. It is used as the initializer
  * for data and method objects.
  *
  * @return A slot vector with the evaluated slots.
  */ 
  protected SlotVector evalSlots() throws dSelfException, NonLocalReturnException{
   
    SlotDecl slotDecl = null;
    Slot slot = null;
    SlotVector slotVector = new SlotVector();
    
    for(int i=0; i<slotDeclarations.getSlotDecls().size(); i++){
      slotDecl = (SlotDecl) slotDeclarations.getSlotDecls().get(i);
      
      if(slotDecl instanceof DataSlotDecl){
        DataSlotDecl dataSlotDecl = (DataSlotDecl) slotDecl;

        if(dataSlotDecl.isParentSlot())
          slot = new ParentSlot(dataSlotDecl.getSlotName(), 
	      dataSlotDecl.evalSlot(), dataSlotDecl.getAnnotation());
        else if(dataSlotDecl.isArgumentSlot())
          slot = new ArgumentSlot(dataSlotDecl.getSlotName(), 
	      dataSlotDecl.evalSlot(), dataSlotDecl.getAnnotation());
        else
          slot = new DataSlotImpl(dataSlotDecl.getSlotName(), 
	      dataSlotDecl.evalSlot(), dataSlotDecl.getAnnotation());

        slotVector.addSlot(slot);

        if(dataSlotDecl.isAssignableSlot())
	  slotVector.addSlot(new AssignmentSlot(dataSlotDecl.getSlotName()+":", 
	      (DataSlot) slot)); 
      }else{	    
        MethodSlotDecl methodSlotDecl = (MethodSlotDecl) slotDecl;
        slot = new MethodSlotImpl(methodSlotDecl.getSlotName(), 
	    methodSlotDecl.evalSlot(), methodSlotDecl.getAnnotation());
        slotVector.addSlot(slot);
      }
    }   
    
    return slotVector;
  }    
}
