package dSelf;

import java.util.Vector;
import dSelfVM;

/**
 * The class TrueSO repesents the true object of dSelf.
 * TrueSO is a primitive dSelf object and so it has only one
 * parent slot called "parent".
 * The object, that "parent" refers to has initialy only one
 * parent slot, also called "parent" that refers to the lobby.
 * This object is dedicated to include the user-defined methods.
 */
public class TrueSO extends BooleanSO{

 /** The parent object for this object*/
  protected static LocalOrdinarySO parent = 
    new LocalOrdinarySO(new ParentSlot("parent", dSelfVM.lobbySO));

 /**
  * The slots for this object. It consists of only one slot
  * called "parent"
  */
  protected static SlotVector slotVector = 
    new SlotVector(new ParentSlot("parent",parent));   
    
 /**
  * The parent slots for all this object. It consists of only one slot
  * called "parent"
  */
  protected static Vector parVector = new Vector();   
  
  static{
    parVector.add(parent);   
  }

 /**
  * Returns the slots of the true object. I.e, it's only one slot
  * called "parent".
  */   
  public SlotVector getSlotVector(){
    
    return slotVector; 
  }
  
 /**
  * Returns the parent slot for the dSelf true object.
  */  
  protected LocalOrdinarySO getParent(){
  
    return parent;
  }
    
 /**
  * Returns the parent slots of the true object. I.e, it's only one 
  * slot called "parent".
  */   
  public Vector getParentVector(){
  
    return parVector;
  }   

 /** Creates a new true object */
  public TrueSO(){}
  
 /**
  * Returns the name of this object. 
  */
  public String getName(){
  
    return "true";
  }
 
 /**
  * Check if the argument is true.
  *
  * @param arg The argument type must be BooleanSO and is checked by
  * the method
  */ 
  protected BooleanSO _Eq(dSelfObject so) throws dSelfException{

    if(!(so instanceof BooleanSO))
      throw new dSelfException("Wrong argument-type send to \"_Eq:\" !"+
          " True or false was expected.", "_Eq:", "badTypeError");

    return (so instanceof TrueSO) ? (BooleanSO)new TrueSO() : (BooleanSO)new FalseSO();
  }  
  
}
