package dSelf;

import java.rmi.*;
import java.net.MalformedURLException;
import java.security.AccessControlException;
import dSelfVM;

/**
 * dSelfObject is the root of all dSelf objects. All objects, that 
 * inherit of it are evaluated objects. See {@link CodeExpr} for 
 * objects, that are not evaluated.
 */
public abstract class dSelfObject{

  /** The name of this object */
  public abstract String getName();
  
  /** Prints an error message for the given exception. */
  protected static void handleException(Exception exception){
  
    if(exception instanceof NotBoundException)
      dSelfVM.printRuntimeError(
         "A VM with this name is not bounded to the registry !\n" + exception);
    else if(exception instanceof AccessException)
      dSelfVM.printRuntimeError(
         "No permissions to access the demanded VM !\n" + exception);
    else if(exception instanceof RemoteException )
      dSelfVM.printRuntimeError(
         "A remote error occured !\n" + exception);
    else if(exception instanceof MalformedURLException)
      dSelfVM.printRuntimeError(
         "The given URL is malformed !\n" + exception);
    else      
      dSelfVM.printRuntimeError("An network error occured !\n" + exception);
      exception.printStackTrace();
  }
  
  /** Returns the hashcode of this object */
  protected int getHashCode(){
  
    return hashCode();
  }
  
  /** Returns the name of the VM, where this object is located */
  protected String getLocation(){

    String hostname;
    try {
      hostname = java.net.InetAddress.getLocalHost().getHostName();
    }catch (java.net.UnknownHostException e) {
      dSelfVM.printMessage("Can not figure out the hostname.");
      hostname = "";
    }
      
    return "//" + hostname + "/" + dSelfVM.VMName;
  }  
}




