package parser;

import java.util.Vector;
import dSelf.CodeExpr;

/**
 * CapKeywordExprList is an utility class for the dSelf-parser.
 * It concatenates the parts of an list of capital keywords and 
 * collects the expressions between them, which are the argument
 * values of the corresponding keyword message.
 */
public final class CapKeywordExprList{

  /** The name of the keyword message (it's trailing, capital part). */
  public String name;

  /** A vector with the arguments of the keyword message.*/
  public Vector methodArgs;
  
  /** Constructor. Creates an empty message.*/
  public CapKeywordExprList(){
  
    methodArgs = new Vector(3);
    name = "";
  }
  
 /** 
  * Creates a new CapKeywordExprList by concatenating the given 
  * CapKeywordExprList with following arguments.
  *
  * @param c The CapKeywordExprList that will be extended.
  * @param n The name of the next capital keyword
  * @param e The expression for the next argument
  */  
  public CapKeywordExprList(CapKeywordExprList c, String n, CodeExpr e){

    name = c.name + n;
    methodArgs = c.methodArgs;  
    methodArgs.addElement(e);
  }

 /**
  * Gives back the current arguments cancatenated with the given argument.
  */
  public Vector getVectorWith(CodeExpr e){
  
    Vector vec = new Vector(3);
   
    vec.addElement(e);
    vec.addAll(methodArgs);
    
    return vec;
  }
}  
