package parser;

import java.util.Vector;
import dSelf.*;

/**
 * CapKeywordIdeList is an utility class for the dSelf-parser.
 * It concatenates the parts of an list of capital keywords and 
 * collects the identifiers between them, which are the argument
 * variables of the corresponding keyword message.
 */
public final class CapKeywordIdeList{

  /** The name of the keyword message (it's trailing, capital part). */
  public String name;

  /** A vector with the arguments of the keyword message.*/
  public SlotDeclarations methodArgs;
  
  /** Constructor. Creates an empty message.*/
  public CapKeywordIdeList(){
  
    methodArgs = new SlotDeclarations();
    name = "";
  }
    
 /** 
  * Creates a new CapKeywordIdeList by concatenating the given 
  * CapKeywordIdeList with following arguments.
  *
  * @param c The CapKeywordIdeList that will be extended.
  * @param n The name of the next capital keyword
  * @param e The identifier for the next argument
  */  
  public CapKeywordIdeList(CapKeywordIdeList c, String n, String a){

    name = c.name + n;
    methodArgs = c.methodArgs;  
    methodArgs.addSlotDecl(new DataSlotDecl(a, false, false, true, new NilSO(), null));
  }

 /**
  * Gives back the current arguments cancatenated with the given argument.
  */
  public SlotDeclarations getDeclarationsWith(String a){
  
    return new SlotDeclarations(new DataSlotDecl(a, false, false, true, 
        new NilSO(), null)).withSlotDeclarations(methodArgs);
//    return methodArgs.withSlotDecl(new DataSlotDecl(a, false, false, true, new NilSO(), null));
  }
}  
