/* The following code was generated by JFlex 1.3.2 on 25/10/01 22:08 */

package parser;

import java_cup.runtime.*;
import dSelf.PrimMsg;
import dSelf.Globals;
import dSelfComp;
import dSelfVM;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.2
 * on 25/10/01 22:08 from the specification file
 * <tt>file:/STORE/usr/local/var/tmp/+diplom-tmp/dself-cvs/parser/dSelfLex.flex</tt>
 */
public class dSelfScanner implements java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int STRING = 1;
  final public static int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\3\1\2\2\0\1\1\22\0\1\3\1\26\1\36\1\26"+
    "\1\26\1\26\1\26\1\42\1\37\1\40\1\27\1\22\1\26\1\11"+
    "\1\17\1\26\1\56\10\63\1\6\1\25\1\26\1\32\1\30\1\26"+
    "\1\31\1\26\3\61\1\24\1\21\1\61\5\5\1\14\5\5\1\10"+
    "\1\16\7\5\1\50\1\33\1\51\1\34\1\12\1\0\1\46\1\55"+
    "\1\60\1\23\1\20\1\45\2\4\1\47\2\4\1\13\1\4\1\41"+
    "\1\62\2\4\1\7\1\15\1\43\1\44\1\54\1\4\1\57\2\4"+
    "\1\52\1\35\1\53\1\26\uff81\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    52,   104,   156,   104,   208,   260,   312,   364,   416, 
      468,   104,   520,   572,   520,   520,   624,   520,   520,   676, 
      728,   104,   780,   104,   832,   884,   104,   104,   104,   104, 
      104,   104,   936,   104,   988,   104,   260,   104,  1040,  1092, 
     1144,  1196,  1248,  1300,  1352,   520,   676,  1404,  1456,   104, 
     1508,  1560,  1612,   104,   104,  1664,   104,   104,   104,   104, 
      104,   104,   104,   104,   104,  1716,  1768,  1820,   104,  1872, 
      104,   104,  1924,  1976,  2028,  2080,  2132,  2184,   208,  2236, 
     2288,  2340,  2392,  2444,   104,  2496,  2548,  2600,   208,   208, 
     2652,  2704,  2756,  2808,   104,   104,   104,  2860,   208,  2912, 
     2964,  3016,  3068,  3120,   104,  3172,  3224,   104,  3276,  3328, 
      104,   104,   104
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\1\3\1\4\2\5\1\6\1\7\1\10\1\11\1\7"+
    "\1\12\2\6\1\7\1\13\1\7\1\14\1\6\1\7"+
    "\1\15\1\6\1\7\1\16\1\15\1\17\1\20\1\15"+
    "\1\21\1\15\1\22\1\23\1\24\1\25\1\26\1\27"+
    "\1\30\1\31\1\6\1\32\2\6\1\33\1\34\1\35"+
    "\1\36\2\6\1\10\2\6\1\7\1\6\1\10\1\37"+
    "\2\0\26\37\1\40\1\37\1\41\6\37\1\42\21\37"+
    "\66\0\1\5\65\0\5\6\1\0\5\6\1\43\2\6"+
    "\1\0\2\6\1\44\13\0\1\6\1\0\5\6\4\0"+
    "\10\6\4\0\5\45\1\0\5\45\1\0\2\45\1\0"+
    "\2\45\1\46\13\0\1\45\1\0\5\45\4\0\10\45"+
    "\6\0\1\10\2\47\1\0\1\50\4\0\1\51\2\52"+
    "\34\0\1\10\4\0\1\10\4\0\5\6\1\0\5\6"+
    "\1\43\1\53\1\6\1\0\2\6\1\44\13\0\1\6"+
    "\1\0\5\6\4\0\10\6\6\0\1\10\2\0\1\15"+
    "\10\0\1\15\3\0\10\15\20\0\1\10\4\0\1\10"+
    "\4\0\5\6\1\0\5\6\1\43\1\54\1\6\1\0"+
    "\2\6\1\44\13\0\1\6\1\0\5\6\4\0\10\6"+
    "\11\0\1\15\10\0\1\15\3\0\10\15\32\0\1\55"+
    "\2\0\1\55\2\0\2\55\1\0\1\55\2\0\1\55"+
    "\2\0\1\55\15\0\1\55\1\0\5\55\4\0\2\55"+
    "\1\0\2\55\1\0\1\55\12\0\1\56\10\0\1\15"+
    "\3\0\10\15\26\0\36\57\1\5\25\57\1\0\3\60"+
    "\31\0\1\61\2\0\1\62\27\0\5\6\1\0\5\6"+
    "\1\43\2\6\1\0\2\6\1\44\13\0\1\6\1\0"+
    "\4\6\1\63\4\0\10\6\4\0\3\6\1\64\1\6"+
    "\1\0\5\6\1\43\2\6\1\0\2\6\1\44\13\0"+
    "\1\6\1\0\5\6\4\0\10\6\4\0\5\6\1\0"+
    "\5\6\1\43\2\6\1\0\2\6\1\44\13\0\1\6"+
    "\1\0\3\6\1\65\1\6\4\0\10\6\7\66\1\67"+
    "\13\66\1\70\7\66\1\71\2\66\1\72\2\66\1\73"+
    "\1\74\1\75\1\66\1\76\6\66\1\77\1\100\1\101"+
    "\1\102\2\66\1\103\1\66\4\0\1\104\2\0\1\104"+
    "\1\0\1\105\2\104\1\0\1\104\2\0\1\104\1\0"+
    "\1\105\1\104\2\0\10\105\3\0\1\104\1\0\5\104"+
    "\4\0\2\104\1\0\2\104\1\0\1\104\5\0\5\106"+
    "\2\0\4\106\1\0\2\106\1\0\2\106\14\0\1\106"+
    "\1\0\5\106\4\0\10\106\13\0\2\107\2\110\53\0"+
    "\1\111\47\0\1\111\4\0\1\111\6\0\1\112\2\0"+
    "\1\113\10\0\1\113\33\0\1\112\4\0\1\112\4\0"+
    "\5\6\1\0\3\6\1\114\1\6\1\43\2\6\1\0"+
    "\2\6\1\44\13\0\1\6\1\0\5\6\4\0\10\6"+
    "\4\0\5\6\1\0\1\6\1\115\3\6\1\43\2\6"+
    "\1\0\2\6\1\44\13\0\1\6\1\0\5\6\4\0"+
    "\10\6\4\0\5\55\1\0\5\55\1\0\2\55\1\0"+
    "\2\55\14\0\1\55\1\0\5\55\4\0\10\55\1\0"+
    "\3\60\34\0\1\62\24\0\3\61\31\0\1\116\32\0"+
    "\5\6\1\0\1\6\1\117\3\6\1\43\2\6\1\0"+
    "\2\6\1\44\13\0\1\6\1\0\5\6\4\0\10\6"+
    "\4\0\5\6\1\0\5\6\1\43\2\6\1\0\2\6"+
    "\1\44\13\0\1\6\1\0\1\6\1\120\3\6\4\0"+
    "\10\6\4\0\5\6\1\0\1\6\1\121\3\6\1\43"+
    "\2\6\1\0\2\6\1\44\13\0\1\6\1\0\5\6"+
    "\4\0\10\6\6\0\1\122\47\0\1\122\4\0\1\122"+
    "\6\0\1\123\11\0\2\123\1\0\2\123\20\0\2\123"+
    "\6\0\2\123\1\0\2\123\1\0\1\123\56\0\1\124"+
    "\4\0\1\124\4\0\5\104\1\0\5\104\1\0\2\104"+
    "\1\0\2\104\1\125\13\0\1\104\1\0\5\104\4\0"+
    "\10\104\4\0\5\106\1\0\1\126\4\106\1\0\2\106"+
    "\1\0\2\106\14\0\1\106\1\0\5\106\4\0\10\106"+
    "\6\0\1\111\3\0\1\127\5\0\2\52\34\0\1\111"+
    "\4\0\1\111\6\0\1\112\3\0\1\127\43\0\1\112"+
    "\4\0\1\112\6\0\1\112\47\0\1\112\4\0\1\112"+
    "\4\0\5\6\1\0\5\6\1\43\1\130\1\6\1\0"+
    "\2\6\1\44\13\0\1\6\1\0\5\6\4\0\10\6"+
    "\4\0\5\6\1\0\5\6\1\43\2\6\1\0\2\6"+
    "\1\44\13\0\1\6\1\0\2\6\1\131\2\6\4\0"+
    "\10\6\40\0\1\62\27\0\5\6\1\0\5\6\1\43"+
    "\1\132\1\6\1\0\2\6\1\44\13\0\1\6\1\0"+
    "\5\6\4\0\10\6\4\0\5\6\1\0\3\6\1\133"+
    "\1\6\1\43\2\6\1\0\2\6\1\44\13\0\1\6"+
    "\1\0\5\6\4\0\10\6\6\0\1\134\47\0\1\134"+
    "\4\0\1\134\6\0\1\135\11\0\2\135\1\0\2\135"+
    "\20\0\2\135\6\0\2\135\1\0\2\135\1\0\1\135"+
    "\56\0\1\136\4\0\1\136\13\0\2\137\2\140\70\0"+
    "\2\141\43\0\5\6\1\0\5\6\1\43\2\6\1\0"+
    "\2\6\1\44\13\0\1\142\1\0\5\6\4\0\10\6"+
    "\4\0\5\6\1\0\5\6\1\43\1\143\1\6\1\0"+
    "\2\6\1\44\13\0\1\6\1\0\5\6\4\0\10\6"+
    "\6\0\1\144\47\0\1\144\4\0\1\144\6\0\1\145"+
    "\11\0\2\145\1\0\2\145\20\0\2\145\6\0\2\145"+
    "\1\0\2\145\1\0\1\145\56\0\1\146\4\0\1\146"+
    "\4\0\5\6\1\0\5\6\1\43\2\6\1\0\1\147"+
    "\1\6\1\44\13\0\1\6\1\0\5\6\4\0\10\6"+
    "\6\0\1\150\47\0\1\150\4\0\1\150\6\0\1\151"+
    "\11\0\2\151\1\0\2\151\20\0\2\151\6\0\2\151"+
    "\1\0\2\151\1\0\1\151\56\0\1\152\4\0\1\152"+
    "\4\0\5\6\1\0\5\6\1\153\2\6\1\0\2\6"+
    "\1\44\13\0\1\6\1\0\5\6\4\0\10\6\6\0"+
    "\1\154\47\0\1\154\4\0\1\154\56\0\1\155\4\0"+
    "\1\155\4\0\1\156\2\0\1\156\1\0\1\157\2\156"+
    "\1\0\1\156\2\0\1\156\1\0\1\157\1\156\2\0"+
    "\10\157\3\0\1\156\1\0\5\156\4\0\2\156\1\0"+
    "\2\156\1\0\1\156\57\0\1\160\4\0\1\160\4\0"+
    "\5\156\1\0\5\156\1\0\2\156\1\0\2\156\1\161"+
    "\13\0\1\156\1\0\5\156\4\0\10\156";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  0,  9,  1,  9,  1,  1,  1,  1,  1,  1,  9,  1,  1,  1,  1, 
     1,  1,  1,  1,  1,  9,  1,  9,  1,  1,  9,  9,  9,  9,  9,  9, 
     1,  9,  0,  9,  0,  9,  0,  0,  0,  0,  1,  1,  1,  1,  0,  0, 
     0,  9,  1,  1,  1,  9,  9,  0,  9,  9,  9,  9,  9,  9,  9,  9, 
     9,  0,  0,  1,  9,  1,  9,  9,  1,  1,  0,  1,  1,  0,  1,  1, 
     1,  1,  1,  1,  9,  0,  0,  1,  1,  1,  1,  1,  1,  1,  9,  9, 
     9,  1,  1,  1,  1,  1,  1,  1,  9,  1,  0,  9,  1,  1,  9,  9,  9
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
    
 /**
  * symbol nimmt einen Symbolwert an (siehe sym.java) und gibt
  * diesen als ein Symbolobjekt mit Informationen zur Spalten-
  * und Zeilenposition im Quelltext, sowie einem Objekt, da
  * z.B. den Wert eines Integers oder den Namen einer Nachricht
  * enthlt zurck. Wenn der Scanner sich im Debugmodus befindet, 
  * werden zustzlich die Tokendaten ausgegeben.
  */

 /**
  * Creats a symbol of the specified type with the given value.
  * The current informations about the line and column are also
  * added. When {@link dSelf.Globals#debug_scanner} is activated,
  * then the tokens are printed. 
  *
  * @param type The type of the token symbol
  * @param value The value of the token symbol
  * @return A symbol object that unites the given informations
  */
  protected Symbol symbol(int type, Object value){
   
    if(Globals.debug_scanner){  
    
      System.out.print("line: "+(yyline+1)+",\tcolumn: "+(yycolumn+1)+",\ttoken:");
      switch(type){
    
        case sym.TRUE: printMessage(" true"); break;
        case sym.FALSE: printMessage(" false"); break;
        case sym.NIL: printMessage(" nil"); break;
        case sym.CIRCUMFLEX: printMessage(" ^"); break;
        case sym.IDENTIFIER: printMessage(" identifier(\""+value+"\")"); break;
        case sym.SMALLKEYWORD: printMessage(" small keyword(\""+value+"\")"); break;
        case sym.CAPKEYWORD: printMessage(" capital keyword(\""+value+"\")"); break;
        case sym.ARGUMENTNAME: printMessage(" argument name(\""+value+"\")"); break;
        case sym.STRING: printMessage(" string(\""+value+"\")"); break;
        case sym.OPERATOR: printMessage(" operator(\""+value+"\")"); break;
        case sym.INTEGER: printMessage(" integer("+value+")"); break;
        case sym.LONG: printMessage(" long("+value+")"); break;
        case sym.SHORT: printMessage(" short("+value+")"); break;
        case sym.FLOAT: printMessage(" float("+value+")"); break;
        case sym.DOUBLE: printMessage(" double("+value+")"); break;
        case sym.LEFTPAR: printMessage(" ("); break;
        case sym.RIGHTPAR: printMessage(" )"); break;
        case sym.SELF_KEYWORD: printMessage(" self"); break;
        case sym.DOT: printMessage(" ."); break;
        case sym.EQUAL: printMessage(" ="); break;
        case sym.LEFTARROW: printMessage(" <-"); break;
        case sym.LEFTBRACE: printMessage(" {"); break;
        case sym.RIGHTBRACE: printMessage(" }"); break;
        case sym.LEFTSQUAREBRACKET: printMessage(" ["); break;
        case sym.RIGHTSQUAREBRACKET: printMessage(" ]"); break;
        case sym.VERTICALBAR: printMessage(" |"); break;
        case sym.ASTERISK: printMessage(" *"); break;
        case sym.EMPTY_OBJECT: printMessage(" empty object"); break;
        case sym.UNARYINDIRECTEDRESEND: printMessage(" unary indirected resend(\""+value+"\")"); break;
        case sym.UNARYDIRECTEDRESEND: printMessage(" unary directed resend(\""+value+"\")"); break;
        case sym.BINARYINDIRECTEDRESEND: printMessage(" binary indirected resend(\""+value+"\")"); break;
        case sym.BINARYDIRECTEDRESEND: printMessage(" binary directed resend(\""+value+"\")"); break;
        case sym.KEYWORDINDIRECTEDRESEND: printMessage(" keyword indirected resend(\""+value+"\")"); break;
        case sym.KEYWORDDIRECTEDRESEND: printMessage(" keyword directed resend(\""+value+"\")"); break;
      }	
    }

    return new Symbol(type, yyline, yycolumn, value);
  } 

    protected void printMessage(String msg)
    {
	if (!Globals.genJava) // called from VM
	    dSelfVM.printMessage(msg);
	else
	    System.out.println(msg);
    }  
 /**
  * calls {@link #symbol(int, Object)} with null as value auf. 
  *
  * @param type The type of the token symbol
  * @return A symbol object that unites the given informations
  */
  protected Symbol symbol(int type){

    return symbol(type, null);
  }

/**
 * Calculates for a given string in the form 'xry' or 'xRy' the 
 * corresponding integer value, where x is a number between 2
 * and 36 (the radix) and y a sequence of digits or letters. E.g.
 * 2r11111, 8r37, 10r31, 16r1f or 36rv all represent the number 31.
 *
 * @param str A string in radix-form
 * @return The corresponding integer value.
 */
 protected int radInt2decInt(String str){
  
    boolean isPositive = true;
    
    // Merken, ob Zahl positiv oder negativ ist  
    if(str.charAt(0) == '-'){
      isPositive = false;  
      str = str.substring(1,str.length());
    }
    
    // r ist die Position des 'r' oder 'R' im String  
    int r = str.indexOf('r') == -1 ? str.indexOf('R') : str.indexOf('r');
		
    // Den String in eine Zahl umwandeln	      
    return string2int((isPositive ? "" : "-") + str, 
        (isPositive ? "" : "-") + str.substring(r+1), 
        Integer.parseInt(str.substring(0, r))); 
  } 

/**
 * Calculates for a given string in radix form the corresponding 
 * long value. The procedure is the same as described at 
 * {@link #radInt2decInt(String)}.
 *
 * @param str A string in radix-form
 * @return The corresponding integer value.
 */
 protected long radLong2decLong(String str){
  
    boolean isPositive = true;
    
    // Merken, ob Zahl positiv oder negativ ist  
    if(str.charAt(0) == '-'){
      isPositive = false;  
      str = str.substring(1,str.length());
    }
    
    // r ist die Position des 'r' oder 'R' im String  
    int r = str.indexOf('r') == -1 ? str.indexOf('R') : str.indexOf('r');
		
    // Den String in eine Zahl umwandeln	      
    return string2long((isPositive ? "" : "-") + str, 
        (isPositive ? "" : "-") + str.substring(r+1), 
        Integer.parseInt(str.substring(0, r))); 
  } 

/**
 * Calculates for a given string in radix form the corresponding 
 * short value. The procedure is the same as described at 
 * {@link #radInt2decInt(String)}.
 *
 * @param str A string in radix-form
 * @return The corresponding integer value.
 */
 protected short radShort2decShort(String str){
  
    boolean isPositive = true;
    
    // Merken, ob Zahl positiv oder negativ ist  
    if(str.charAt(0) == '-'){
      isPositive = false;  
      str = str.substring(1,str.length());
    }
    
    // r ist die Position des 'r' oder 'R' im String  
    int r = str.indexOf('r') == -1 ? str.indexOf('R') : str.indexOf('r');
		
    // Den String in eine Zahl umwandeln	      
    return string2short((isPositive ? "" : "-") + str, 
        (isPositive ? "" : "-") + str.substring(r+1), 
        Integer.parseInt(str.substring(0, r))); 
  } 

 /**
  * Converts a string that consists of digits and letters in a
  * decimal integer number. The radix is a number between 2 and 36
  * (e.g. 16 is hexadecimal system) and numstr is the string, that
  * should be converted. 
  *
  * @param radix A number between 2 and 36
  * @param numStr The string, that should be converted
  */  
  protected int string2int(String numStr, int radix){
  
    return string2int(numStr, numStr, radix);
  }
 
 /**
  * Converts a string that consists of digits and letters in a
  * decimal long number. The procedure is the same as described
  * at {@link #string2int(String, int)}.
  *
  * @param radix A number between 2 and 36
  * @param numStr The string, that should be converted
  */  
  protected long string2long(String numStr, int radix){
  
    return string2long(numStr, numStr, radix);
  }

 /**
  * Converts a string that consists of digits and letters in a
  * decimal short number. The procedure is the same as described
  * at {@link #string2int(String, int)}.
  *
  * @param radix A number between 2 and 36
  * @param numStr The string, that should be converted
  */  
  protected short string2short(String numStr, int radix){
  
    return string2short(numStr, numStr, radix);
  }

 /**
  * This method does the same like {@link #string2int(String, int)},
  * but in case of an error an more detailed error message is printed
  * with a reference of its occurence.
  *
  * @param origStr The string, where numStr was embedded
  * @param numStr The string, that should be converted
  * @param radix A number between 2 and 36
  */
  protected int string2int(String origStr, String numStr, int radix){

    // Die Basis mu zwischen 2 und 36 liegen
    if(radix < 2 || radix > 36){ 
      dSelfComp.reportError("The radix of "+origStr+" isn't between 2 and 36 !",
                          yyline, yycolumn); 
      
      // When an error occured, then guess the radix as the maximium
      // possible.
      radix=36;
    }
    
    int result=0;
    
    // Try to convert the string to a number by using integers parseInt
    // method. If an error occures in form of an exception, then convert
    // it again "manually" in order to find the exact position, where
    // the error occured and give more detailed informations back.
    try{  
      result = Integer.parseInt(numStr, radix);
    }catch(NumberFormatException e){

      int endPos = numStr.length()-1;  
      int actPos = endPos;
      int digit = 0;
      result =0;
      
      while(actPos >= 0){
        if((digit = Character.digit(numStr.charAt(actPos), radix)) == -1
	    && numStr.charAt(actPos) != '-')
          dSelfComp.reportError("The digit "+numStr.charAt(actPos)+" in "+origStr
	                       +" is to big !", yyline, yycolumn);             
        else 
          result += Math.pow(radix, endPos-actPos)*digit;
  
        actPos--;       
      }
    }

    return result;
    
  }

 /**
  * This method does the same like {@link #string2long(String, int)},
  * but in case of an error an more detailed error message is printed
  * with a reference of its occurence.
  *
  * @param origStr The string, where numStr was embedded
  * @param numStr The string, that should be converted
  * @param radix A number between 2 and 36
  */
  protected long string2long(String origStr, String numStr, int radix){

    // Die Basis mu zwischen 2 und 36 liegen
    if(radix < 2 || radix > 36){ 
      dSelfComp.reportError("The radix of "+origStr+" isn't between 2 and 36 !",
                          yyline, yycolumn); 
      
      // When an error occured, then guess the radix as the maximium
      // possible.
      radix=36;
    }
    
    long result=0;
    
    // Try to convert the string to a number by using integers parseInt
    // method. If an error occures in form of an exception, then convert
    // it again "manually" in order to find the exact position, where
    // the error occured and give more detailed informations back.
    try{  
      result = Long.parseLong(numStr, radix);
    }catch(NumberFormatException e){

      int endPos = numStr.length()-1;  
      int actPos = endPos;
      int digit = 0;
      result =0;
      
      while(actPos >= 0){
        if((digit = Character.digit(numStr.charAt(actPos), radix)) == -1
	    && numStr.charAt(actPos) != '-')
          dSelfComp.reportError("The digit "+numStr.charAt(actPos)+" in "+origStr
	                       +" is to big !", yyline, yycolumn);             
        else 
          result += Math.pow(radix, endPos-actPos)*digit;
  
        actPos--;       
      }
    }
     
    return result;
  }
  
 /**
  * This method does the same like {@link #string2short(String, int)},
  * but in case of an error an more detailed error message is printed
  * with a reference of its occurence.
  *
  * @param origStr The string, where numStr was embedded
  * @param numStr The string, that should be converted
  * @param radix A number between 2 and 36
  */
  protected short string2short(String origStr, String numStr, int radix){

    // Die Basis mu zwischen 2 und 36 liegen
    if(radix < 2 || radix > 36){ 
      dSelfComp.reportError("The radix of "+origStr+" isn't between 2 and 36 !",
                          yyline, yycolumn); 
      
      // When an error occured, then guess the radix as the maximium
      // possible.
      radix=36;
    }
    
    short result=0;
    
    // Try to convert the string to a number by using integers parseInt
    // method. If an error occures in form of an exception, then convert
    // it again "manually" in order to find the exact position, where
    // the error occured and give more detailed informations back.
    try{  
      result = Short.parseShort(numStr, radix);
    }catch(NumberFormatException e){

      int endPos = numStr.length()-1;  
      int actPos = endPos;
      int digit = 0;
      result =0;
      
      while(actPos >= 0){
        if((digit = Character.digit(numStr.charAt(actPos), radix)) == -1
	    && numStr.charAt(actPos) != '-')
          dSelfComp.reportError("The digit "+numStr.charAt(actPos)+" in "+origStr
	                       +" is to big !", yyline, yycolumn);             
        else 
          result += Math.pow(radix, endPos-actPos)*digit;
  
        actPos--;       
      }
    }
     
    return result;
  }  

  /** A dSelf string, that will be convertet to a Java string.*/
  protected StringBuffer string = new StringBuffer();
    


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public dSelfScanner(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public dSelfScanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[3380];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 150) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Gets the next input character.
   *
   * @return      the next character of the input stream, EOF if the
   *              end of the stream is reached.
   * @exception   IOException  if any I/O-Error occurs
   */
  private int yy_advance() throws java.io.IOException {

    /* standard case */
    if (yy_currentPos < yy_endRead) return yy_buffer[yy_currentPos++];

    /* if the eof is reached, we don't need to work hard */ 
    if (yy_atEOF) return YYEOF;

    /* otherwise: need to refill the buffer */

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if ( numRead == -1 ) return YYEOF;

    yy_endRead+= numRead;

    return yy_buffer[yy_currentPos++];
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() throws java.io.IOException {
    if (!yy_eof_done) {
      yy_eof_done = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int yy_input;
    int yy_action;


    while (true) {

      boolean yy_r = false;
      for (yy_currentPos = yy_startRead; yy_currentPos < yy_markedPos;
                                                      yy_currentPos++) {
        switch (yy_buffer[yy_currentPos]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          yy_r = false;
          yycolumn++;
        }
      }

      if (yy_r) {
        if ( yy_advance() == '\n' ) yyline--;
        if ( !yy_atEOF ) yy_currentPos--;
      }

      yy_action = -1;

      yy_currentPos = yy_startRead = yy_markedPos;

      yy_state = yy_lexical_state;


      yy_forAction: {
        while (true) {

          yy_input = yy_advance();

          if ( yy_input == YYEOF ) break yy_forAction;

          int yy_next = yytrans[ yy_rowMap[yy_state] + yycmap[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = YY_ATTRIBUTE[yy_state];
          if ( (yy_attributes & 1) > 0 ) {
            yy_action = yy_state; 
            yy_markedPos = yy_currentPos; 
            if ( (yy_attributes & 8) > 0 ) break yy_forAction;
          }

        }
      }


      switch (yy_action) {

        case 33: 
          {  yybegin(YYINITIAL); return symbol(sym.STRING, string.toString()); }
        case 114: break;
        case 112: 
          {  if(yytext().charAt(7) == '_')
                              dSelfComp.reportError("Resending of primitives is not "+
                                  "allowed !", yyline, yycolumn); 
                             return symbol(sym.KEYWORDINDIRECTEDRESEND, yytext().substring(7)); 
			   }
        case 115: break;
        case 111: 
          {  int iVal=string2int(yytext().substring(2),yytext().substring(2),8);
          if(iVal > 65535){
            dSelfComp.reportError("Illegal escape-character \""+yytext()+"\" in"+
	        "String. \n-- Allowed maximum is: \\o177777", yyline, yycolumn);
	  }	
	  string.append((char)iVal);		
	  }
        case 116: break;
        case 110: 
          {  return symbol(sym.BINARYINDIRECTEDRESEND, yytext().substring(7));  }
        case 117: break;
        case 109: 
          {  if(yytext().charAt(7) == '_')
                              dSelfComp.reportError("Resending of primitives is not "+
                                  "allowed !", yyline, yycolumn); 
                             return symbol(sym.UNARYINDIRECTEDRESEND, yytext().substring(7)); 
			   }
        case 118: break;
        case 107: 
          {  int iVal = (new Integer(yytext().substring(2))).intValue();
          if(iVal > 65535)
             dSelfComp.reportError("Illegal escape-character \""+yytext()+"\" in"+
	         "String. \n-- Allowed maximum is: \\d65535", yyline, yycolumn);
	  string.append((char)iVal);		

         }
        case 119: break;
        case 98: 
          {  return symbol(sym.FALSE);  }
        case 120: break;
        case 96: 
          {  return symbol(sym.DOUBLE, Double.valueOf(yytext().substring(0, yytext().length()-2)+'d'));  }
        case 121: break;
        case 95: 
          {  return symbol(sym.SHORT, new Short(radShort2decShort(yytext().substring(0, yytext().length()-2))));  }
        case 122: break;
        case 94: 
          {  return symbol(sym.LONG, new Long(radLong2decLong(yytext().substring(0, yytext().length()-2))));  }
        case 123: break;
        case 89: 
          {  return symbol(sym.TRUE);  }
        case 124: break;
        case 88: 
          {  return symbol(sym.SELF_KEYWORD);  }
        case 125: break;
        case 84: 
          {  if(yytext().charAt(yytext().indexOf('.')+1) == '_')
                              dSelfComp.reportError("Resending of primitives is not "+
                                  "allowed !", yyline, yycolumn); 
			     return symbol(sym.KEYWORDDIRECTEDRESEND, yytext()); 
			   }
        case 126: break;
        case 78: 
          {  return symbol(sym.NIL);  }
        case 127: break;
        case 72: 
        case 73: 
          {  // Well formed Self literals are syntacticaly a subset of the
                     // well formed Java literals.
                     return symbol(sym.FLOAT, Float.valueOf(yytext()+'f')); 
		    }
        case 128: break;
        case 71: 
          {  short s=0;
                     try{  
                       s = Short.parseShort(yytext().substring(0, yytext().length()-2));
                     }catch(NumberFormatException e){
                       s = string2short(yytext().substring(0, yytext().length()-2), 10); 
                     }
                     return symbol(sym.SHORT, new Short(s)); 
		    }
        case 129: break;
        case 70: 
          {  long l=0;
                     try{  
                       l = Long.parseLong(yytext().substring(0, yytext().length()-2));
                     }catch(NumberFormatException e){
                       l = string2long(yytext().substring(0, yytext().length()-2), 10); 
                     }
                     return symbol(sym.LONG, new Long(l)); 
		    }
        case 130: break;
        case 69: 
          {  return symbol(sym.INTEGER, new Integer(radInt2decInt(yytext())));  }
        case 131: break;
        case 68: 
          {  return symbol(sym.BINARYDIRECTEDRESEND, yytext());  }
        case 132: break;
        case 67: 
          {  if(yytext().charAt(yytext().indexOf('.')+1) == '_')
                              dSelfComp.reportError("Resending of primitives is not "+
                                  "allowed !", yyline, yycolumn); 
                             return symbol(sym.UNARYDIRECTEDRESEND, yytext()); 
			   }
        case 133: break;
        case 64: 
          {  string.append('\0');  }
        case 134: break;
        case 29: 
          {  return symbol(sym.RIGHTBRACE);  }
        case 135: break;
        case 28: 
          {  return symbol(sym.LEFTBRACE);  }
        case 136: break;
        case 27: 
          {  return symbol(sym.RIGHTSQUAREBRACKET);  }
        case 137: break;
        case 26: 
          {  return symbol(sym.LEFTSQUAREBRACKET);  }
        case 138: break;
        case 23: 
          {  string.setLength(0); yybegin(STRING);  }
        case 139: break;
        case 21: 
          {  return symbol(sym.RIGHTPAR);  }
        case 140: break;
        case 20: 
          {  return symbol(sym.LEFTPAR);  }
        case 141: break;
        case 18: 
          {  return symbol(sym.VERTICALBAR);  }
        case 142: break;
        case 17: 
          {  return symbol(sym.CIRCUMFLEX);  }
        case 143: break;
        case 2: 
        case 6: 
        case 13: 
        case 19: 
          {  dSelfComp.reportError("Character \""+yytext()+"\" is not "+
                         "allowed there !", yyline, yycolumn); 
		    }
        case 144: break;
        case 3: 
        case 4: 
          {  /* skip */  }
        case 145: break;
        case 5: 
        case 8: 
        case 10: 
        case 22: 
        case 24: 
        case 25: 
        case 42: 
        case 43: 
        case 50: 
        case 51: 
        case 52: 
        case 75: 
        case 76: 
        case 79: 
        case 80: 
        case 87: 
        case 90: 
        case 97: 
        case 102: 
          {  return symbol(sym.IDENTIFIER, yytext());  }
        case 146: break;
        case 7: 
          {  int i=0;
                     try{  
                       i = Integer.parseInt(yytext());
                     }catch(NumberFormatException e){
                       i = string2int(yytext(), 10); 
                     }
                     return symbol(sym.INTEGER, new Integer(i)); 
		    }
        case 147: break;
        case 9: 
        case 12: 
        case 16: 
          {  return symbol(sym.OPERATOR, yytext());  }
        case 148: break;
        case 11: 
          {  return symbol(sym.DOT);  }
        case 149: break;
        case 14: 
          {  return symbol(sym.ASTERISK);  }
        case 150: break;
        case 15: 
          {  return symbol(sym.EQUAL);  }
        case 151: break;
        case 30: 
        case 32: 
          {  string.append(yytext());  }
        case 152: break;
        case 31: 
          {  string.append('?');  }
        case 153: break;
        case 35: 
          {  return symbol(sym.SMALLKEYWORD, yytext());  }
        case 154: break;
        case 37: 
          {  return symbol(sym.CAPKEYWORD, yytext());  }
        case 155: break;
        case 44: 
          {  return symbol(sym.ARGUMENTNAME, yytext().substring(1, yytext().length()));  }
        case 156: break;
        case 45: 
          {  return symbol(sym.LEFTARROW);  }
        case 157: break;
        case 49: 
          {  return symbol(sym.EMPTY_OBJECT);  }
        case 158: break;
        case 53: 
          {  dSelfComp.reportError("Illegal escape-character \"" + yytext() +
                 "\" in String", yyline, yycolumn);
              }
        case 159: break;
        case 54: 
          {  string.append('\r');  }
        case 160: break;
        case 56: 
          {  string.append('\\');  }
        case 161: break;
        case 57: 
          {  string.append('\"');  }
        case 162: break;
        case 58: 
          {  string.append('\n');  }
        case 163: break;
        case 59: 
          {  string.append('\'');  }
        case 164: break;
        case 60: 
          {  string.append('\t');  }
        case 165: break;
        case 61: 
          {  string.append('\f');  }
        case 166: break;
        case 62: 
          {  string.append('\u000b');  }
        case 167: break;
        case 63: 
          {  string.append('\b');  }
        case 168: break;
        case 104: 
          {  string.append((char)string2int(yytext().substring(2),
	      yytext().substring(2),16));
	 }
        case 169: break;
        case 81: 
        case 82: 
        case 83: 
        case 91: 
        case 92: 
        case 93: 
        case 99: 
        case 100: 
        case 101: 
        case 103: 
        case 105: 
        case 108: 
          {  dSelfComp.reportError("Illegal escape-character \""+yytext()+"\" in"+
	      " String. The Number must begin with 0's to have"+
	      " the right size, e.g. \\x00ff instead of \\xff." );
	 }
        case 170: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
              { return new java_cup.runtime.Symbol(sym.EOF); }
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }


}
