package floweditor.component;

import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import java.util.Enumeration;

import javax.swing.JTextField;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.util.Log;

/** Klasse die Interface eines beliebigen Attributes darstellt. */
public class AttrCDATA
    extends javax.swing.JTextField
    implements CompEventHandler, FocusListener
{
    Component _owner;
    AttDef    _attDef;
    boolean _isValid;

    protected AttrCDATA (Component owner, AttDef attDef, int columns) 
    {
	super (columns);
	_owner  = owner;
	_attDef = attDef;
	_isValid = false;

	String attributeName  = _attDef.getName ();
	String attributeValue = _owner.getAttribute (attributeName);
	String ownerName      = _owner.getTagName ();
	
	this.setText (attributeValue);
	this.addFocusListener (this);
        Log.file(1,"AttrDOCUMENTATION(Component, AttDef, String)",
		 ownerName + "::" +
                 attributeName + "::" + 
                 attributeValue);
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore	
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrCDATA", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setText(value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	
	String attrValue = this.getText ();
	if (_attDef.getDeclaredType () == AttDef.REQUIRED) {
            if (attrValue == null || ((attrValue.trim()).length () == 0)) 
                throw new NotWellFormedDocument ("Error: no value for " +
                                                 "attribute defined! " +
						 "please enter a value",
                                                 _owner);
        }
    }

    //////////////////////////////////////////////
    //       Implementation of FocusListener    //
    //////////////////////////////////////////////
    public void focusGained (FocusEvent event)
    {

    }

    public void focusLost (FocusEvent event)
    {
        String attributeValue = this.getText();
        String attributeName  =  _attDef.getName();
        _owner.setAttribute (attributeName, attributeValue);
        _owner.changeAttributeEvent ((CompEventHandler) this, 
                                     attributeName, 
                                     attributeValue);   
        Log.file (3,"Attr" + attributeName, 
                  "focusLost(FocusEvent)",
                  "attrvalue = " + attributeValue);
    }

}
