package floweditor.pool.MODEL.ACTIVITY;

import java.awt.Color;
import com.ibm.graph.ext.visual.VisualVertex;

import floweditor.component.Component;
import floweditor.component.CompGraph;

/**
 *  Klasse die die graphische Darstellung der
 *  ACTIVITY-Komponente definiert.
*/
public class ActivityGraph 
    extends VisualVertex
    implements CompGraph
{
    
    public ActivityGraph (Component component, String label)
    {
	super (VisualVertex.RECTANGLE, // vertex's shape 
	       Color.yellow,           // fill color      
	       Color.black,            // border color
	       false,                  // text to be printed isn't vertex's key
	       "ACT" + label,          // the text to be shown whitin Rectangle
	       Color.black);           // text color
	
	_component = component;

	setSize (_width, _height);
	try {
	    setMarginTop ((_height - getFontSizeDefault ())/2 );
	} catch (Exception e) {
	    e.printStackTrace ();
	}
    }
    
    ///////////////////////////////////////
    //    Implementation of CompGraph    //
    ///////////////////////////////////////
    
    /** berprft ob ACTIVITY ein Knoten ist.
	@return true immer, da ACTIVITY-Komponente
	innerhalb einer WORKFLOW als Knoten dargestellt wird.
    */
    public boolean isVertex () 
    {
	return true;
    }
    
    public Component getComponent () 
    {
	return _component;
    }

    Component _component;
    private int _width  = 80;
    private int _height = 50;
}




