package floweditor.util;

import java.awt.Point  ;
import java.lang.*;
import java.util.*;
import com.ibm.xml.parser.*;
import floweditor.component.NotWellFormedDocument;
import floweditor.component.Component;

public class TopologicalSort {

    /**
     *
     */
    public TopologicalSort() {}

    /**
     *
     */

    public Topology sort(TXElement[] activities, TXElement[] transitions) 
	throws NotWellFormedDocument
    {
	prepare(activities, transitions);
	dfs();
 	criticalPath();
	convertToPosition();
	return new Topology (_pointTable,_transitionClass, _activityTable );
    }

    Hashtable _activityTable = new Hashtable();     // ID -> Component
    Hashtable _successorTable = new Hashtable();    // ID -> <ID>
    Hashtable _predecessorTable = new Hashtable();  // ID -> <ID>
    Hashtable _labelTable = new Hashtable();        // ID -> Tripple
    Hashtable _transitionClass = new Hashtable();   // Edge -> EdgeType
    Hashtable _pointTable      = new Hashtable();   // ID -> Point
    TreeSet    _startIDs = new TreeSet();

    private int _timer = 1;
    
    /**
     *
     */
    public void prepare(TXElement[] activities, TXElement[] transitions) 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "prepare(TXElement[],TXElement[] )");
	_activityTable.clear();
	_successorTable.clear();
	_predecessorTable.clear();
	_labelTable.clear();
	_transitionClass.clear();
	_startIDs.clear();
	_timer = 0;

	// init _activityTabl
	for(int i = 0; i < activities.length; i++) {
	    final String id = activities[i].getAttribute("ID");
	    if ((id.trim()).length() == 0) {
		throw new NotWellFormedDocument("Attribut ID ungltig", 
						(Component) activities[i]);
	    }
	    _activityTable.put(id, activities[i]);
	    _successorTable.put(id, new TreeSet());
	    _predecessorTable.put(id, new TreeSet());
	    _labelTable.put(id, new Label(Label.WHITE, 0, 0));
	}
	
	// init _successorTable 
	for(int i = 0; i < transitions.length; i++) {
	    final String from = transitions[i].getAttribute("FROM");
	    final String to   = transitions[i].getAttribute("TO");
	    
	    if (((from.trim()).length() == 0) 
		|| ((to.trim()).length() == 0)) {
		throw new NotWellFormedDocument("Attribut FROM bzw. "
						+ "TO ungltig", 
						(Component) transitions[i]);
	    }

	    
	    try {
		TreeSet succs   = (TreeSet) _successorTable.get(from);
		TreeSet preds   = (TreeSet) _predecessorTable.get(to);
		if ((succs == null) || (preds == null)) {
		    String  mesg 
			=  "Attribut FROM bzw. TO verweist "
			+ "nicht auf gltigen Knoten";
		    Component comp = (Component) transitions[i];
		    throw new NotWellFormedDocument(mesg, comp);
		}
		succs.add(to);
		preds.add(from);
		_transitionClass.put(new Edge(from,to), 
				     new EdgeType(EdgeType.TREE_EDGES));
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	
	// suche Knoten, die keine eingehenden Kanten hat
	Enumeration idEnum = _predecessorTable.keys();
	while(idEnum.hasMoreElements()) {
	    try {
		String id = (String) idEnum.nextElement();
		TreeSet preds = (TreeSet) _predecessorTable.get(id);
		if (preds.size() == 0) {
		    _startIDs.add(id);
		}
		// clear vector for later use
		// preds.clear();
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }
    
    /**
     *
     */
    private void prepare(String[] activities, String[][] transitions) 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "prepare(String[]x, String[][])");

	_activityTable.clear();
	_successorTable.clear();
	_predecessorTable.clear();
	_labelTable.clear();
	_transitionClass.clear();
	_startIDs.clear();
	_timer = 0;

	// init _activityTabl
	for(int i = 0; i < activities.length; i++) {
	    final String id = activities[i];
	    _activityTable.put(id, activities[i]);
	    _successorTable.put(id, new TreeSet());
	    _predecessorTable.put(id, new TreeSet());
	    _labelTable.put(id, new Label(Label.WHITE, 0, 0));
	}
       
	for(int i = 0; i < transitions.length; i++) {
	    final String from = transitions[i][0];
	    final String to   = transitions[i][1];
	    
	    try {
		TreeSet succs   = (TreeSet) _successorTable.get(from);
		TreeSet preds   = (TreeSet) _predecessorTable.get(to);
		if ((succs == null) || (preds == null)) {
		    String  mesg 
			=  "Attribut FROM bzw. TO verweist "
			+ "nicht auf gltigen Knoten";
		    throw new NotWellFormedDocument(mesg, null);
		}
		succs.add(to);
		preds.add(from);
		_transitionClass.put(new Edge(from,to), 
				    new EdgeType(EdgeType.TREE_EDGES));
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
	
	// suche Knoten, die keine eingehenden Kanten hat
	Enumeration idEnum = _predecessorTable.keys();
	while(idEnum.hasMoreElements()) {
	    try {
		String id = (String) idEnum.nextElement();
		TreeSet preds = (TreeSet) _predecessorTable.get(id);
		if (preds.size() == 0) {
		    _startIDs.add(id);
		}
		// clear vector for later use
		// preds.clear();
	    } catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }
 
    /**
     *
     */
    private void dfs() 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "dfs()");
	Iterator iter = _startIDs.iterator();
	while(iter.hasNext()) {
	    try {
		String U = (String) iter.next();
		Label label = (Label) _labelTable.get(U);
		if (label._color == Label.WHITE) {
		    dfsVisit(U);
		}
	    } catch (Exception e) {
		// cant happen
		e.printStackTrace();
	    }
	}
    }


    /**
     *
     */
    private void dfsVisit(String U) 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "dfsVisit(String)");
	Log.file(2, "TopologicalSort", "dfsVisit(String)", U);
	try {
	    _timer++;
	    Label U_label = (Label) _labelTable.get(U);
	    U_label._color    = Label.GREY;
	    U_label._discover = _timer;
	    TreeSet U_succs = (TreeSet) _successorTable.get(U);
	    Log.file(1, "TopologicalSort", "dfsVisit(String)", 
		     U_succs.toString());
	    Iterator U_succs_iter = U_succs.iterator();
	    //	    for (int i = 0; i < U_succs.size(); i++) {
	    while(U_succs_iter.hasNext()) {
		String V = (String) U_succs_iter.next();
		Label V_label = (Label) _labelTable.get(V);
		switch (V_label._color) {
		case Label.WHITE:
		    // Vector V_preds = (Vector) _predecessorTable.get(V);
		    // V_preds.add(U);
		    dfsVisit(V);
		    break;
		case Label.GREY: 
		    {
			EdgeType UV_edgeType 
			    = (EdgeType) _transitionClass.get(new Edge(U,V));
			UV_edgeType._type = EdgeType.BACK_EDGES;
		    }
		    break;
		case Label.BLACK:
		    {
			EdgeType UV_edgeType 
			    = (EdgeType) _transitionClass.get(new Edge(U,V));
			UV_edgeType._type = EdgeType.FORWARD_EDGES;
		    }
		    break;
		default:
		    System.err.println("---- unknown node color ----");
		    //e.printStackTrace();
		}
	    }
	    U_label._color = Label.BLACK;
	    _timer++;
	    U_label._finish = _timer;
	} catch (Exception e) {
	    // FIXME
	    throw new NotWellFormedDocument("Fehler whrend Tiefensuche", 
					    null);
	}
    }
    
    /**
     *
     */
    private void criticalPath() 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "criticalPath()");

	/**
	 * reset labels of all vertices */
	try {
	    Enumeration keyEnum = _labelTable.keys();
	    while(keyEnum.hasMoreElements()) {
		Label label = (Label) _labelTable.get(keyEnum.nextElement());
		label._color = Label.WHITE;
		label._finish   = -1;
		label._discover = -1;
	    }
	} catch (Exception e) {
	    // never happens
	}

	Iterator iter = _startIDs.iterator();
	while (iter.hasNext()) {
	    try {
		String U = (String) iter.next();
		Label U_label = (Label) _labelTable.get(U);
		if (U_label._color == Label.WHITE) {
		    criticalPathVisit(U);
		}
	    } catch (Exception e) {
		// cant happen
		e.printStackTrace();
	    }
	}
    }

    
    /**
     *
     */
    private void criticalPathVisit(String U ) 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "layerSort()");
	try {
	    // are all predecessors already visited?
	    // visited nodes are BLACK
	    // ignore nodes that are reached by BACK_EDGES

	    boolean allPredsBlack = true; 
	    /* if one is not BLACK, change to false */

	    int     maxFinishTime   = -1;  
	    /* important for start node, that is labeled with 0 */ 

	    TreeSet  U_preds = (TreeSet) _predecessorTable.get(U);
	    Iterator U_preds_iter = U_preds.iterator();
	    while (U_preds_iter.hasNext() && allPredsBlack) {
		String T = (String) U_preds_iter.next();
		EdgeType TU_edgeType 
		    = (EdgeType) _transitionClass.get( new Edge(T,U));
		Label T_label = (Label) _labelTable.get(T);
		switch (TU_edgeType._type) {
		case EdgeType.BACK_EDGES:
		    // ignore this predecessor, because it is a backward edge
		    break;
		case EdgeType.TREE_EDGES:
		case EdgeType.FORWARD_EDGES:
		case EdgeType.CROSS_EDGES:
		    // fall through
		default:
		    // node T is relevant node and must be analyzed
		    switch(T_label._color) {
		    case Label.WHITE:
		    case Label.GREY:
			allPredsBlack = false;	
			break;
		    case Label.BLACK:
			// fall through
		    default:
			// allPredsBlack = true; 
			maxFinishTime 
			    = (maxFinishTime < T_label._finish)
			    ? T_label._finish : maxFinishTime;
		    }
		}

	    } // while

	    if (allPredsBlack) {
		Label U_label = (Label) _labelTable.get(U);
		U_label._color = Label.BLACK;
		U_label._finish = maxFinishTime + 1;
		
		/**
		 * visit all successor nodes that are not connected by
		 * BACK_EDGES */
		TreeSet U_succs = (TreeSet) _successorTable.get(U);
		Iterator U_succs_iter = U_succs.iterator();
		while (U_succs_iter.hasNext()) {
		    String V = (String) U_succs_iter.next();
		    EdgeType UV_edgeType 
			= (EdgeType) _transitionClass.get( new Edge(U,V));
		    
		    switch (UV_edgeType._type) {
		    case EdgeType.BACK_EDGES:
			/*
			 * ignore this successor, because it is a
			 * backward edge */
			break;
		    case EdgeType.TREE_EDGES:
		    case EdgeType.FORWARD_EDGES:
		    case EdgeType.CROSS_EDGES:
			// fall through
		    default:
			// node T is relevant node and must be analyzed
			criticalPathVisit(V);
		    }
		}       /* while */
	    }      /*  if */
	    
	    // return to sender

	} catch (Exception e) {
	    // never happens
	} 
    }

    /**
     *
     */
    private void convertToPosition() 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "layerSort()");
	try {
	    int row = 0;
	    Iterator startIter = _startIDs.iterator();
	    while(startIter.hasNext()) {
		String U = (String) startIter.next();
		int breadth = fixate(U, row);
		row = row + breadth;
	    }
	} catch (Exception e) {
	    // ignore
	}
    }
    
    private int fixate(String U, int upperRow) {
	TreeSet U_succs = (TreeSet) _successorTable.get(U);
	Iterator U_succs_iter = U_succs.iterator();
	int breadth = 0;
	while(U_succs_iter.hasNext()) {
	    String V = (String) U_succs_iter.next();
	    EdgeType UV_edgeType = (EdgeType) _transitionClass.get( new Edge(U,V));
	    switch(UV_edgeType._type) {
	    case EdgeType.TREE_EDGES:
		int delta = fixate(V, upperRow + breadth);
		breadth = breadth + delta;
		break;
	    case EdgeType.BACK_EDGES:
		breadth = breadth + 2;
	    default:
		/*
		 * ignore this successor, because it is a
		 * backward edge */
	    }
	}
	Label U_label = (Label) _labelTable.get(U);
	int nodeColumn = U_label._finish;
	int nodeRow    = upperRow + (breadth / 2);
	_pointTable.put(U, new Point(nodeColumn, nodeRow));
	
	return (breadth == 0) ? 1 : breadth;
    }

    private void run(String []vertices, String [][] edges  )
	throws NotWellFormedDocument
    {
	prepare(vertices, edges);
	dfs();
	criticalPath();
	convertToPosition();
	// return _pointTable;
	Log.file(1, "TopologicalSort", "main(String[]) _startIDs", 
		 _startIDs.toString());
	Log.file(1, "TopologicalSort", "main(String[]) _activityTable", 
		 _activityTable.toString());
	Log.file(1, "TopologicalSort", "main(String[]) _successorTable", 
		 _successorTable.toString());
	Log.file(1, "TopologicalSort", "main(String[]) _predecessorTable", 
		 _predecessorTable.toString());
	Log.file(1, "TopologicalSort", "main(String[]) _transitionClass", 
		 _transitionClass.toString());
	Log.file(1, "TopologicalSort", "main(String[]) _labelTable", 
		 _labelTable.toString());
	Log.file(1, "TopologicalSort", "main(String[]) _pointTable", 
		 _pointTable.toString());
    }

    /**
     *
     */
    public static void main(String[] args) 
	throws NotWellFormedDocument
    {
	Log.file(1, "TopologicalSort", "main(String[])");

	String [] vertices = {"1","2", "3","4","5","6","7","8","9",
			      "10","11","12"};
	String [][] edges 
	    = {
		{"1","2"},
		{"1","3"},
		{"2","4"},
		{"3","4"},
		{"3","6"},
		{"4","5"},
		{"6","7"},
		{"7","8"},
		{"5","8"},
		{"6","9"},
		{"9","3"},
		{"10","11"},
		{"10","12"},
		{"10","2"},
		{"1","7"}
	    };


	TopologicalSort sorter = new TopologicalSort();
	sorter.run(vertices, edges);
    }
    

    /**
     *
     */
    private class Label {
	final static int WHITE = 0;
	final static int GREY  = 1;
	final static int BLACK = 2;

	public Label(int color, int discover, int finish) {
	    _color = color;
	    _discover = discover;
	    _finish = finish;
	}

	public int _color;
	public int _discover;
	public int _finish;

	public String toString() { 
	    switch(_color) {
	    case WHITE:
		return "(white," + _discover + "," + _finish + ")";
	    case GREY:
		return "(grey," + _discover + "," + _finish + ")";
	    case BLACK:
		return "(black," + _discover + "," + _finish + ")";
	    default:
		return "(??," + _discover + "," + _finish + ")";
	    }
	}
    }
}
